/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip.utils;

import com.android.builder.internal.packaging.zip.utils.CloseableDelegateByteSource;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteTracker {
    private long mBytesUsed;
    private long mMaxBytesUsed;

    public CloseableDelegateByteSource fromStream(InputStream stream) throws IOException {
        byte[] data = ByteStreams.toByteArray((InputStream)stream);
        this.updateUsage(data.length);
        return new CloseableDelegateByteSource(ByteSource.wrap((byte[])data), data.length){

            @Override
            public synchronized void innerClose() throws IOException {
                super.innerClose();
                ByteTracker.this.updateUsage(-this.sizeNoException());
            }
        };
    }

    public CloseableDelegateByteSource fromStream(ByteArrayOutputStream stream) throws IOException {
        byte[] data = stream.toByteArray();
        this.updateUsage(data.length);
        return new CloseableDelegateByteSource(ByteSource.wrap((byte[])data), data.length){

            @Override
            public synchronized void innerClose() throws IOException {
                super.innerClose();
                ByteTracker.this.updateUsage(-this.sizeNoException());
            }
        };
    }

    public CloseableDelegateByteSource fromSource(ByteSource source) throws IOException {
        return this.fromStream(source.openStream());
    }

    private synchronized void updateUsage(long delta) {
        this.mBytesUsed += delta;
        if (this.mMaxBytesUsed < this.mBytesUsed) {
            this.mMaxBytesUsed = this.mBytesUsed;
        }
    }

    public synchronized long getBytesUsed() {
        return this.mBytesUsed;
    }

    public synchronized long getMaxBytesUsed() {
        return this.mMaxBytesUsed;
    }
}

