/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Uninstaller;
import com.android.repository.io.FileOp;

public abstract class AbstractInstallerFactory
implements InstallerFactory {
    private InstallerFactory.StatusChangeListenerFactory mListenerFactory;

    @Override
    public void setListenerFactory(InstallerFactory.StatusChangeListenerFactory listenerFactory) {
        this.mListenerFactory = listenerFactory;
    }

    @Override
    public final Installer createInstaller(RemotePackage p, RepoManager mgr, Downloader downloader, FileOp fop) {
        Installer installer = this.doCreateInstaller(p, mgr, downloader, fop);
        this.registerListeners(installer);
        return installer;
    }

    private void registerListeners(PackageOperation op) {
        if (this.mListenerFactory != null) {
            for (PackageOperation.StatusChangeListener listener : this.mListenerFactory.createListeners(op.getPackage())) {
                op.registerStateChangeListener(listener);
            }
        }
    }

    protected abstract Installer doCreateInstaller(RemotePackage var1, RepoManager var2, Downloader var3, FileOp var4);

    @Override
    public final Uninstaller createUninstaller(LocalPackage p, RepoManager mgr, FileOp fop) {
        Uninstaller uninstaller = this.doCreateUninstaller(p, mgr, fop);
        this.registerListeners(uninstaller);
        return uninstaller;
    }

    protected abstract Uninstaller doCreateUninstaller(LocalPackage var1, RepoManager var2, FileOp var3);
}

