/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.tasks.Comment;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.apache.axis.utils.XMLChar;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="YouTrack")
public class YouTrackRepository
extends BaseRepositoryImpl {
    private String myDefaultSearch = "Assignee: me sort by: updated #Unresolved";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.tasks.youtrack.YouTrackRepository");

    public YouTrackRepository() {
    }

    public YouTrackRepository(TaskRepositoryType type) {
        super(type);
    }

    @NotNull
    public BaseRepository clone() {
        return new YouTrackRepository(this);
    }

    private YouTrackRepository(YouTrackRepository other) {
        super((BaseRepositoryImpl)other);
        this.myDefaultSearch = other.getDefaultSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task[] getIssues(@Nullable String request, int max, long since) throws Exception {
        String query = this.getDefaultSearch();
        if (StringUtil.isNotEmpty((String)request)) {
            query = query + " " + request;
        }
        String requestUrl = "/rest/project/issues/?filter=" + YouTrackRepository.encodeUrl((String)query) + "&max=" + max + "&updatedAfter" + since;
        HttpMethod method = this.doREST(requestUrl, false);
        try {
            Element element;
            InputStream stream = method.getResponseBodyAsStream();
            String s = StreamUtil.readText((InputStream)stream, (Charset)CharsetToolkit.UTF8_CHARSET);
            for (int i = 0; i < s.length(); ++i) {
                if (XMLChar.isValid((int)s.charAt(i))) continue;
                s = s.replace(s.charAt(i), ' ');
            }
            try {
                element = new SAXBuilder(false).build((Reader)new StringReader(s)).getRootElement();
            }
            catch (JDOMException e) {
                LOG.error("Can't parse YouTrack response for " + requestUrl, (Throwable)e);
                throw e;
            }
            if ("error".equals(element.getName())) {
                throw new Exception("Error from YouTrack for " + requestUrl + ": '" + element.getText() + "'");
            }
            List children = element.getChildren("issue");
            List tasks = ContainerUtil.mapNotNull((Collection)children, (Function)new NullableFunction<Element, Task>(){

                public Task fun(Element o) {
                    return YouTrackRepository.this.createIssue(o);
                }
            });
            Task[] taskArray = tasks.toArray(new Task[tasks.size()]);
            return taskArray;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        PostMethod method = new PostMethod(this.getUrl() + "/rest/user/login");
        return new BaseRepositoryImpl.HttpTestConnection<PostMethod>(method){

            protected void doTest(PostMethod method) throws Exception {
                YouTrackRepository.this.login(method);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient login(PostMethod method) throws Exception {
        String response;
        HttpClient client = this.getHttpClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getUsername(), this.getPassword()));
        this.configureHttpMethod((HttpMethod)method);
        method.addParameter("login", this.getUsername());
        method.addParameter("password", this.getPassword());
        client.getParams().setContentCharset("UTF-8");
        client.executeMethod((HttpMethod)method);
        try {
            if (method.getStatusCode() != 200) {
                throw new Exception("Cannot login: HTTP status code " + method.getStatusCode());
            }
            response = method.getResponseBodyAsString(1000);
        }
        finally {
            method.releaseConnection();
        }
        if (response == null) {
            throw new NullPointerException();
        }
        if (!response.contains("<login>ok</login>")) {
            int length;
            int pos = response.indexOf("</error>");
            if (pos > (length = "<error>".length())) {
                response = response.substring(length, pos);
            }
            throw new Exception("Cannot login: " + response);
        }
        return client;
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        Element element = this.fetchRequestAsElement(id);
        return element.getName().equals("issue") ? this.createIssue(element) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Element fetchRequestAsElement(@NotNull String id) throws Exception {
        HttpMethod method = this.doREST("/rest/issue/byid/" + id, false);
        try {
            InputStream stream = method.getResponseBodyAsStream();
            Element element = new SAXBuilder(false).build(stream).getRootElement();
            return element;
        }
        finally {
            method.releaseConnection();
        }
    }

    HttpMethod doREST(String request, boolean post) throws Exception {
        HttpClient client = this.login(new PostMethod(this.getUrl() + "/rest/user/login"));
        String uri = this.getUrl() + request;
        PostMethod method = post ? new PostMethod(uri) : new GetMethod(uri);
        this.configureHttpMethod((HttpMethod)method);
        int status = client.executeMethod((HttpMethod)method);
        if (status == 400) {
            InputStream string = method.getResponseBodyAsStream();
            Element element = new SAXBuilder(false).build(string).getRootElement();
            TaskUtil.prettyFormatXmlToLog(LOG, element);
            if ("error".equals(element.getName())) {
                throw new Exception(element.getText());
            }
        }
        return method;
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        this.doREST("/rest/issue/execute/" + task.getId() + "?command=" + YouTrackRepository.encodeUrl((String)("state " + state.getId())), true).releaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        HttpMethod method = this.doREST("/rest/issue/" + task.getId() + "/execute/intellisense?command=" + YouTrackRepository.encodeUrl((String)"state: "), false);
        try {
            InputStream stream = method.getResponseBodyAsStream();
            Element element = new SAXBuilder(false).build(stream).getRootElement();
            Set set = ContainerUtil.map2Set((Collection)element.getChild("suggest").getChildren("item"), (Function)new Function<Element, CustomTaskState>(){

                public CustomTaskState fun(Element element) {
                    String stateName = element.getChildText("option");
                    return new CustomTaskState(stateName, stateName);
                }
            });
            return set;
        }
        finally {
            method.releaseConnection();
        }
    }

    @Nullable
    private Task createIssue(Element element) {
        final String id = element.getAttributeValue("id");
        if (id == null) {
            return null;
        }
        final String summary = element.getAttributeValue("summary");
        if (summary == null) {
            return null;
        }
        final String description = element.getAttributeValue("description");
        String type = element.getAttributeValue("type");
        TaskType taskType = TaskType.OTHER;
        if (type != null) {
            try {
                taskType = TaskType.valueOf((String)type.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        final TaskType finalTaskType = taskType;
        final Date updated = new Date(Long.parseLong(element.getAttributeValue("updated")));
        final Date created = new Date(Long.parseLong(element.getAttributeValue("created")));
        final boolean resolved = element.getAttribute("resolved") != null;
        return new Task(){

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return YouTrackRepository.this.getUrl() + "/issue/" + this.getId();
            }

            @NotNull
            public String getId() {
                return id;
            }

            @NotNull
            public String getSummary() {
                return summary;
            }

            public String getDescription() {
                return description;
            }

            @NotNull
            public Comment[] getComments() {
                return Comment.EMPTY_ARRAY;
            }

            @NotNull
            public Icon getIcon() {
                return LocalTaskImpl.getIconFromType(this.getType(), this.isIssue());
            }

            @NotNull
            public TaskType getType() {
                return finalTaskType;
            }

            @Nullable
            public Date getUpdated() {
                return updated;
            }

            @Nullable
            public Date getCreated() {
                return created;
            }

            public boolean isClosed() {
                return resolved;
            }

            public TaskRepository getRepository() {
                return YouTrackRepository.this;
            }
        };
    }

    public String getDefaultSearch() {
        return this.myDefaultSearch;
    }

    public void setDefaultSearch(String defaultSearch) {
        if (defaultSearch != null) {
            this.myDefaultSearch = defaultSearch;
        }
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        YouTrackRepository repository = (YouTrackRepository)((Object)o);
        return Comparing.equal((String)repository.getDefaultSearch(), (String)this.getDefaultSearch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        this.checkVersion();
        String command = YouTrackRepository.encodeUrl((String)String.format("work Today %s %s", timeSpent, comment));
        HttpMethod method = this.doREST("/rest/issue/execute/" + task.getId() + "?command=" + command, true);
        try {
            if (method.getStatusCode() != 200) {
                InputStream stream = method.getResponseBodyAsStream();
                String message = new SAXBuilder(false).build(stream).getRootElement().getText();
                throw new Exception(message);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion() throws Exception {
        HttpMethod method = this.doREST("/rest/workflow/version", false);
        try {
            boolean timeTrackingAvailable;
            InputStream stream = method.getResponseBodyAsStream();
            Element element = new SAXBuilder(false).build(stream).getRootElement();
            boolean bl = timeTrackingAvailable = element.getName().equals("version") && VersionComparatorUtil.compare((String)element.getChildText("version"), (String)"4.1") >= 0;
            if (!timeTrackingAvailable) {
                throw new Exception("Time tracking is not supported in this version of Youtrack");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    protected int getFeatures() {
        return super.getFeatures() | 4 | 8;
    }

    public HttpClient getHttpClient() {
        return super.getHttpClient();
    }
}

