/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello.model;

import com.google.gson.annotations.SerializedName;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import com.intellij.tasks.trello.model.TrelloLabel;
import com.intellij.tasks.trello.model.TrelloModel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloCard
extends TrelloModel {
    public static final String REQUIRED_FIELDS = "closed,desc,idMembers,idBoard,idList,idShort,labels,name,url,dateLastActivity";
    private String idBoard;
    private String idList;
    private String idShort;
    private List<String> idMembers;
    private String name;
    @SerializedName(value="desc")
    private String description;
    private String url;
    private boolean closed;
    private Date dateLastActivity;
    private List<TrelloLabel> labels;
    @SerializedName(value="actions")
    private List<TrelloCommentAction> comments = ContainerUtil.emptyList();
    private boolean isVisible = true;

    public String toString() {
        return String.format("TrelloCard(id='%s', name='%s')", this.getId(), this.name);
    }

    @NotNull
    public String getIdBoard() {
        return this.idBoard;
    }

    @NotNull
    public String getIdList() {
        return this.idList;
    }

    @NotNull
    public String getIdShort() {
        return this.idShort;
    }

    @NotNull
    public List<String> getIdMembers() {
        return this.idMembers;
    }

    @Override
    @Attribute(value="name")
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public List<TrelloLabel> getLabels() {
        return this.labels;
    }

    @NotNull
    public List<TrelloCommentAction> getComments() {
        return this.comments;
    }

    @NotNull
    public Set<TrelloLabel.LabelColor> getColors() {
        if (this.labels == null || this.labels.isEmpty()) {
            return EnumSet.noneOf(TrelloLabel.LabelColor.class);
        }
        return EnumSet.copyOf(ContainerUtil.mapNotNull(this.labels, (Function)new Function<TrelloLabel, TrelloLabel.LabelColor>(){

            public TrelloLabel.LabelColor fun(TrelloLabel label) {
                TrelloLabel.LabelColor color = label.getColor();
                return color == TrelloLabel.LabelColor.NO_COLOR ? null : color;
            }
        }));
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Nullable
    public Date getDateLastActivity() {
        return this.dateLastActivity;
    }
}

