/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.build.gradle.tasks.SimpleWorkQueue;
import com.android.builder.core.VariantType;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.Task;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import proguard.ClassPath;

public class ProGuardTransform
extends BaseProguardAction {
    private final VariantScope variantScope;
    private final boolean asJar;
    private final boolean isLibrary;
    private final boolean isTest;
    private final File proguardOut;
    private final File printMapping;
    private final File dump;
    private final File printSeeds;
    private final File printUsage;
    private final ImmutableList<File> secondaryFileOutputs;
    private File testedMappingFile = null;
    private Configuration testMappingConfiguration = null;

    public ProGuardTransform(VariantScope variantScope, boolean asJar) {
        super(variantScope);
        this.variantScope = variantScope;
        this.asJar = true;
        this.isLibrary = variantScope.getVariantData().getType() == VariantType.LIBRARY;
        this.isTest = variantScope.getTestedVariantData() != null;
        GlobalScope globalScope = variantScope.getGlobalScope();
        this.proguardOut = new File(Joiner.on((char)File.separatorChar).join((Object)String.valueOf(globalScope.getBuildDir()), (Object)"outputs", new Object[]{"mapping", variantScope.getVariantConfiguration().getDirName()}));
        this.printMapping = new File(this.proguardOut, "mapping.txt");
        this.dump = new File(this.proguardOut, "dump.txt");
        this.printSeeds = new File(this.proguardOut, "seeds.txt");
        this.printUsage = new File(this.proguardOut, "usage.txt");
        this.secondaryFileOutputs = ImmutableList.of((Object)this.printMapping, (Object)this.dump, (Object)this.printSeeds, (Object)this.printUsage);
    }

    public File getMappingFile() {
        return this.printMapping;
    }

    public void applyTestedMapping(File testedMappingFile) {
        this.testedMappingFile = testedMappingFile;
    }

    public void applyTestedMapping(Configuration testMappingConfiguration) {
        this.testMappingConfiguration = testMappingConfiguration;
    }

    public String getName() {
        return "proguard";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JARS;
    }

    public Collection<File> getSecondaryFileInputs() {
        ArrayList files = Lists.newArrayList();
        File testedMappingFile = this.computeMappingFile();
        if (testedMappingFile != null) {
            files.add(testedMappingFile);
        }
        files.addAll(this.getAllConfigurationFiles());
        return files;
    }

    public Collection<File> getSecondaryFileOutputs() {
        return this.secondaryFileOutputs;
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(final TransformInvocation invocation) throws TransformException {
        Job job = new Job(this.getName(), (Task)new Task<Void>(){

            public void run(Job<Void> job, JobContext<Void> context) throws IOException {
                ProGuardTransform.this.doMinification(invocation.getInputs(), invocation.getReferencedInputs(), invocation.getOutputProvider());
            }
        });
        try {
            SimpleWorkQueue.push((Job<Void>)job);
            if (!job.awaitRethrowExceptions()) {
                throw new RuntimeException("Job failed, see logs for details");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private void doMinification(Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider output) throws IOException {
        Preconditions.checkNotNull((Object)output, (Object)("Missing output object for transform " + this.getName()));
        Set outputTypes = this.getOutputTypes();
        Set<QualifiedContent.Scope> scopes = this.getScopes();
        File outFile = output.getContentLocation("main", outputTypes, scopes, this.asJar ? Format.JAR : Format.DIRECTORY);
        if (this.asJar) {
            FileUtils.mkdirs((File)outFile.getParentFile());
        } else {
            FileUtils.mkdirs((File)outFile);
        }
        try {
            File[] jars;
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            File testedMappingFile = this.computeMappingFile();
            if (testedMappingFile != null) {
                this.applyMapping(testedMappingFile);
            }
            this.addInputsToConfiguration(inputs, false);
            this.addInputsToConfiguration(referencedInputs, true);
            for (File runtimeJar : globalScope.getAndroidBuilder().getBootClasspath(true)) {
                this.libraryJar(runtimeJar);
            }
            this.outJar(outFile);
            FileUtils.mkdirs((File)this.proguardOut);
            for (File configFile : this.getAllConfigurationFiles()) {
                this.applyConfigurationFile(configFile);
            }
            this.configuration.printMapping = this.printMapping;
            this.configuration.dump = this.dump;
            this.configuration.printSeeds = this.printSeeds;
            this.configuration.printUsage = this.printUsage;
            this.forceprocessing();
            this.runProguard();
            if (!this.asJar && (jars = outFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String name) {
                    return name.endsWith(".jar");
                }
            })) != null) {
                for (File jarFile : jars) {
                    String jarFileName = jarFile.getName();
                    File to = output.getContentLocation(jarFileName.substring(0, jarFileName.length() - ".jar".length()), outputTypes, scopes, Format.JAR);
                    FileUtils.mkdirs((File)to.getParentFile());
                    FileUtils.renameTo((File)jarFile, (File)to);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private void addInputsToConfiguration(Collection<TransformInput> inputs, boolean referencedOnly) {
        List baseFilter;
        ClassPath classPath;
        if (referencedOnly) {
            classPath = this.configuration.libraryJars;
            baseFilter = JAR_FILTER;
        } else {
            classPath = this.configuration.programJars;
            baseFilter = null;
        }
        for (TransformInput transformInput : inputs) {
            for (JarInput jarInput : transformInput.getJarInputs()) {
                ProGuardTransform.handleQualifiedContent(classPath, (QualifiedContent)jarInput, baseFilter);
            }
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                ProGuardTransform.handleQualifiedContent(classPath, (QualifiedContent)directoryInput, baseFilter);
            }
        }
    }

    private static void handleQualifiedContent(ClassPath classPath, QualifiedContent content, List<String> baseFilter) {
        ImmutableList filter = baseFilter;
        if (!content.getContentTypes().contains(QualifiedContent.DefaultContentType.CLASSES)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (filter != null) {
                builder.addAll(filter);
            }
            builder.add((Object)"!**.class");
            filter = builder.build();
        } else if (!content.getContentTypes().contains(QualifiedContent.DefaultContentType.RESOURCES)) {
            filter = ImmutableList.of((Object)"**.class");
        }
        ProGuardTransform.inputJar(classPath, content.getFile(), (List<String>)filter);
    }

    private File computeMappingFile() {
        if (this.testedMappingFile != null && this.testedMappingFile.isFile()) {
            return this.testedMappingFile;
        }
        if (this.testMappingConfiguration != null && this.testMappingConfiguration.getSingleFile().isFile()) {
            return this.testMappingConfiguration.getSingleFile();
        }
        return null;
    }
}

