/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.aapt.AaptGradleFactory;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.Aapt;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.signing.KeytoolException;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class InstantRunSplitApkBuilder
extends BaseTask {
    private Set<File> dexFolders;
    private File outputDirectory;
    private SigningConfig signingConf;
    private String applicationId;
    private InstantRunBuildContext instantRunBuildContext;
    private File supportDir;
    private File incrementalDir;
    private int versionCode;
    private String versionName;
    private Aapt aapt;

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Input
    public int getVersionCode() {
        return this.versionCode;
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.versionName;
    }

    @InputFiles
    public Set<File> getDexFolders() {
        return this.dexFolders;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public File getZipAlignExe() {
        return null;
    }

    @TaskAction
    public void run(IncrementalTaskInputs inputs) throws IOException, KeytoolException, PackagerException, ProcessException, InterruptedException {
        if (inputs.isIncremental()) {
            inputs.outOfDate(inputFileDetails -> {
                try {
                    if (!inputFileDetails.getFile().getName().contains("main_slice")) {
                        this.generateSplitApk(new DexFile(inputFileDetails.getFile(), inputFileDetails.getFile().getParentFile().getName()));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            inputs.removed(inputFileDetails -> {
                DexFile dexFile = new DexFile(inputFileDetails.getFile(), inputFileDetails.getFile().getParentFile().getName());
                String outputFileName = dexFile.encodeName() + "_unaligned.apk";
                new File(this.getOutputDirectory(), outputFileName).delete();
                outputFileName = dexFile.encodeName() + ".apk";
                new File(this.getOutputDirectory(), outputFileName).delete();
            });
        } else {
            ArrayList<DexFile> allFiles = new ArrayList<DexFile>();
            for (File dexFolder : this.getDexFolders()) {
                File[] files;
                if (!dexFolder.isDirectory() || (files = dexFolder.listFiles()) == null) continue;
                for (File file : files) {
                    allFiles.add(new DexFile(file, dexFolder.getName()));
                }
            }
            for (DexFile file : allFiles) {
                if (file.dexFile.getParentFile().getName().contains("main_slice")) continue;
                this.generateSplitApk(file);
            }
        }
    }

    private void generateSplitApk(DexFile file) throws IOException, DuplicateFileException, KeytoolException, PackagerException, InterruptedException, ProcessException {
        File outputLocation = new File(this.getOutputDirectory(), file.encodeName() + "_unaligned.apk");
        Files.createParentDirs((File)outputLocation);
        File resPackageFile = this.generateSplitApkManifest(file.encodeName());
        this.getBuilder().packageCodeSplitApk(resPackageFile.getAbsolutePath(), file.dexFile, this.signingConf, outputLocation);
        File alignedOutput = new File(this.getOutputDirectory(), file.encodeName() + ".apk");
        ProcessInfoBuilder processInfoBuilder = new ProcessInfoBuilder();
        processInfoBuilder.setExecutable(this.getZipAlignExe());
        processInfoBuilder.addArgs("-f", "4");
        processInfoBuilder.addArgs(outputLocation.getAbsolutePath());
        processInfoBuilder.addArgs(alignedOutput.getAbsolutePath());
        this.getBuilder().executeProcess(processInfoBuilder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
        this.instantRunBuildContext.addChangedFile(InstantRunBuildContext.FileType.SPLIT, alignedOutput);
        resPackageFile.delete();
    }

    private File generateSplitApkManifest(String uniqueName) throws IOException, ProcessException, InterruptedException {
        String versionNameToUse = this.getVersionName();
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(this.getVersionCode());
        }
        File sliceSupportDir = new File(this.supportDir, uniqueName);
        sliceSupportDir.mkdirs();
        File androidManifest = new File(sliceSupportDir, "AndroidManifest.xml");
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(androidManifest), "UTF-8");){
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + this.getApplicationId() + "\"\n" + "      android:versionCode=\"" + this.getVersionCode() + "\"\n" + "      android:versionName=\"" + versionNameToUse + "\"\n" + "      split=\"lib_" + uniqueName + "_apk\">\n" + "</manifest>\n");
            fileWriter.flush();
        }
        File resFilePackageFile = new File(this.supportDir, "resources_ap");
        AaptPackageConfig.Builder aaptConfig = new AaptPackageConfig.Builder().setManifestFile(androidManifest).setOptions((com.android.builder.model.AaptOptions)this.getAaptOptions()).setDebuggable(true).setVariantType(VariantType.DEFAULT).setResourceOutputApk(resFilePackageFile);
        this.getBuilder().processResources(this.aapt, aaptConfig, false);
        return resFilePackageFile;
    }

    public AaptOptions getAaptOptions() {
        return null;
    }

    public static class ConfigAction
    implements TaskConfigAction<InstantRunSplitApkBuilder> {
        private final PackagingScope packagingScope;

        public ConfigAction(PackagingScope packagingScope) {
            this.packagingScope = packagingScope;
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("buildInstantRunPureSplits");
        }

        @Override
        public Class<InstantRunSplitApkBuilder> getType() {
            return InstantRunSplitApkBuilder.class;
        }

        @Override
        public void execute(InstantRunSplitApkBuilder task) {
            AndroidBuilder androidBuilder = this.packagingScope.getAndroidBuilder();
            task.outputDirectory = this.packagingScope.getInstantRunSplitApkOutputFolder();
            task.signingConf = this.packagingScope.getSigningConfig();
            task.setApplicationId(this.packagingScope.getApplicationId());
            task.setVariantName(this.packagingScope.getFullVariantName());
            task.setAndroidBuilder(androidBuilder);
            task.instantRunBuildContext = this.packagingScope.getInstantRunBuildContext();
            task.supportDir = this.packagingScope.getInstantRunSupportDir();
            task.incrementalDir = this.packagingScope.getIncrementalDir(task.getName());
            task.versionCode = this.packagingScope.getVersionCode();
            task.versionName = this.packagingScope.getVersionName();
            task.aapt = AaptGradleFactory.make(androidBuilder, true, true, this.packagingScope.getProject(), this.packagingScope.getVariantType(), FileUtils.mkdirs((File)new File(this.packagingScope.getIncrementalDir(this.getName()), "aapt-temp")), 0);
            ConventionMappingHelper.map((Task)task, "zipAlignExe", () -> {
                TargetInfo info = androidBuilder.getTargetInfo();
                if (info == null) {
                    return null;
                }
                String path1 = info.getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN);
                if (path1 == null) {
                    return null;
                }
                return new File(path1);
            });
            ConventionMappingHelper.map((Task)task, "dexFolders", this.packagingScope::getDexFolders);
            ConventionMappingHelper.map((Task)task, "aaptOptions", this.packagingScope::getAaptOptions);
        }
    }

    private static class DexFile {
        private final File dexFile;
        private final String dexFolderName;

        private DexFile(File dexFile, String dexFolderName) {
            this.dexFile = dexFile;
            this.dexFolderName = dexFolderName;
        }

        private String encodeName() {
            return this.dexFolderName.replace('-', '_');
        }
    }
}

