/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.process.ProcessException;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class GenerateApkDataTask
extends BaseTask {
    private File apkFile;
    private File resOutputDir;
    private File manifestFile;
    private String mainPkgName;
    private int minSdkVersion;
    private int targetSdkVersion;

    @Input
    String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @TaskAction
    void generate() throws IOException, ProcessException, LoggedErrorException, InterruptedException {
        AndroidBuilder builder = this.getBuilder();
        File outDir = this.getResOutputDir();
        FileUtils.cleanOutputDir((File)outDir);
        File apk = this.getApkFile();
        if (apk != null) {
            File rawDir = new File(outDir, "raw");
            FileUtils.mkdirs((File)rawDir);
            File to = new File(rawDir, "android_wear_micro_apk.apk");
            Files.copy((File)apk, (File)to);
            builder.generateApkData(apk, outDir, this.getMainPkgName(), "android_wear_micro_apk");
        } else {
            builder.generateUnbundledWearApkData(outDir, this.getMainPkgName());
        }
        AndroidBuilder.generateApkDataEntryInManifest((int)this.getMinSdkVersion(), (int)this.getTargetSdkVersion(), (File)this.getManifestFile());
    }

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @InputFile
    @Optional
    public File getApkFile() {
        return this.apkFile;
    }

    public void setApkFile(File apkFile) {
        this.apkFile = apkFile;
    }

    @Input
    public String getMainPkgName() {
        return this.mainPkgName;
    }

    public void setMainPkgName(String mainPkgName) {
        this.mainPkgName = mainPkgName;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public void setMinSdkVersion(int minSdkVersion) {
        this.minSdkVersion = minSdkVersion;
    }

    @Input
    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    public void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
    }

    @OutputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateApkDataTask> {
        VariantScope scope;
        Configuration config;

        public ConfigAction(VariantScope scope, Configuration config) {
            this.scope = scope;
            this.config = config;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("handle", "MicroApk");
        }

        @Override
        public Class<GenerateApkDataTask> getType() {
            return GenerateApkDataTask.class;
        }

        @Override
        public void execute(GenerateApkDataTask task) {
            final ApkVariantData variantData = (ApkVariantData)this.scope.getVariantData();
            variantData.generateApkDataTask = task;
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setVariantName(this.scope.getVariantConfiguration().getFullName());
            task.setResOutputDir(this.scope.getMicroApkResDirectory());
            if (this.config != null) {
                ConventionMappingHelper.map((Task)task, "apkFile", new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return (File)config.getFiles().iterator().next();
                    }
                });
            }
            task.setManifestFile(this.scope.getMicroApkManifestFile());
            ConventionMappingHelper.map((Task)task, "mainPkgName", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return variantData.getVariantConfiguration().getApplicationId();
                }
            });
            ConventionMappingHelper.map((Task)task, "minSdkVersion", new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel();
                }
            });
            ConventionMappingHelper.map((Task)task, "targetSdkVersion", new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return variantData.getVariantConfiguration().getTargetSdkVersion().getApiLevel();
                }
            });
        }
    }
}

