/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class SourceProviderContainerImpl
implements SourceProviderContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final SourceProvider sourceProvider;

    static SourceProviderContainer clone(SourceProviderContainer sourceProviderContainer) {
        return SourceProviderContainerImpl.create(sourceProviderContainer.getArtifactName(), sourceProviderContainer.getSourceProvider());
    }

    static List<SourceProviderContainer> cloneCollection(Collection<SourceProviderContainer> containers) {
        return containers.stream().map(SourceProviderContainerImpl::clone).collect(Collectors.toList());
    }

    static SourceProviderContainer create(String name, SourceProvider sourceProvider) {
        return new SourceProviderContainerImpl(name, SourceProviderImpl.cloneProvider(sourceProvider));
    }

    private SourceProviderContainerImpl(String name, SourceProvider sourceProvider) {
        this.name = name;
        this.sourceProvider = sourceProvider;
    }

    public String getArtifactName() {
        return this.name;
    }

    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

