/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.BaseArtifactImpl;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.ClassField;
import com.android.builder.model.Dependencies;
import com.android.builder.model.InstantRun;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.SourceProvider;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AndroidArtifactImpl
extends BaseArtifactImpl
implements AndroidArtifact,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Collection<AndroidArtifactOutput> outputs;
    private final boolean isSigned;
    private final String signingConfigName;
    private final String applicationId;
    private final String sourceGenTaskName;
    private final List<File> generatedResourceFolders;
    private final Set<String> abiFilters;
    private final Collection<NativeLibrary> nativeLibraries;
    private final Map<String, ClassField> buildConfigFields;
    private final Map<String, ClassField> resValues;
    private final InstantRun instantRun;

    AndroidArtifactImpl(String name, Collection<AndroidArtifactOutput> outputs, String assembleTaskName, boolean isSigned, String signingConfigName, String applicationId, String sourceGenTaskName, String compileTaskName, List<File> generatedSourceFolders, List<File> generatedResourceFolders, File classesFolder, File javaResourcesFolder, Dependencies compileDependencies, Dependencies packageDependencies, SourceProvider variantSourceProvider, SourceProvider multiFlavorSourceProviders, Set<String> abiFilters, Collection<NativeLibrary> nativeLibraries, Map<String, ClassField> buildConfigFields, Map<String, ClassField> resValues, InstantRun instantRun) {
        super(name, assembleTaskName, compileTaskName, classesFolder, javaResourcesFolder, compileDependencies, packageDependencies, variantSourceProvider, multiFlavorSourceProviders, generatedSourceFolders);
        this.outputs = outputs;
        this.isSigned = isSigned;
        this.signingConfigName = signingConfigName;
        this.applicationId = applicationId;
        this.sourceGenTaskName = sourceGenTaskName;
        this.generatedResourceFolders = generatedResourceFolders;
        this.abiFilters = abiFilters;
        this.nativeLibraries = nativeLibraries;
        this.buildConfigFields = buildConfigFields;
        this.resValues = resValues;
        this.instantRun = instantRun;
    }

    public Collection<AndroidArtifactOutput> getOutputs() {
        return this.outputs;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getSigningConfigName() {
        return this.signingConfigName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSourceGenTaskName() {
        return this.sourceGenTaskName;
    }

    public Set<String> getIdeSetupTaskNames() {
        return Sets.newHashSet((Object[])new String[]{this.getSourceGenTaskName()});
    }

    public List<File> getGeneratedResourceFolders() {
        return this.generatedResourceFolders;
    }

    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    public Collection<NativeLibrary> getNativeLibraries() {
        return this.nativeLibraries;
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.buildConfigFields;
    }

    public Map<String, ClassField> getResValues() {
        return this.resValues;
    }

    public InstantRun getInstantRun() {
        return this.instantRun;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidArtifactImpl that = (AndroidArtifactImpl)o;
        return this.isSigned == that.isSigned && Objects.equal(this.outputs, that.outputs) && Objects.equal((Object)this.signingConfigName, (Object)that.signingConfigName) && Objects.equal((Object)this.applicationId, (Object)that.applicationId) && Objects.equal((Object)this.sourceGenTaskName, (Object)that.sourceGenTaskName) && Objects.equal(this.generatedResourceFolders, that.generatedResourceFolders) && Objects.equal(this.abiFilters, that.abiFilters) && Objects.equal(this.nativeLibraries, that.nativeLibraries) && Objects.equal(this.buildConfigFields, that.buildConfigFields) && Objects.equal(this.resValues, that.resValues) && Objects.equal((Object)this.instantRun, (Object)that.instantRun);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.outputs, this.isSigned, this.signingConfigName, this.applicationId, this.sourceGenTaskName, this.generatedResourceFolders, this.abiFilters, this.nativeLibraries, this.buildConfigFields, this.resValues, this.instantRun});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("outputs", this.outputs).add("isSigned", this.isSigned).add("signingConfigName", (Object)this.signingConfigName).add("applicationId", (Object)this.applicationId).add("sourceGenTaskName", (Object)this.sourceGenTaskName).add("generatedResourceFolders", this.generatedResourceFolders).add("abiFilters", this.abiFilters).add("nativeLibraries", this.nativeLibraries).add("buildConfigFields", this.buildConfigFields).add("resValues", this.resValues).add("instantRun", (Object)this.instantRun).toString();
    }
}

