/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.internal.incremental.Constructor;
import com.android.build.gradle.internal.incremental.ConstructorBuilder;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.StringSwitch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class IncrementalChangeVisitor
extends IncrementalVisitor {
    public static final IncrementalVisitor.VisitorBuilder VISITOR_BUILDER = new IncrementalVisitor.VisitorBuilder(){

        @Override
        public IncrementalVisitor build(ClassNode classNode, List<ClassNode> parentNodes, ClassVisitor classVisitor) {
            return new IncrementalChangeVisitor(classNode, parentNodes, classVisitor);
        }

        @Override
        public String getMangledRelativeClassFilePath(String path) {
            return path.substring(0, path.length() - 6) + IncrementalChangeVisitor.OVERRIDE_SUFFIX + ".class";
        }

        @Override
        public IncrementalVisitor.OutputType getOutputType() {
            return IncrementalVisitor.OutputType.OVERRIDE;
        }
    };
    private static final boolean DEBUG = false;
    public static final String OVERRIDE_SUFFIX = "$override";
    private static final String METHOD_MANGLE_PREFIX = "static$";
    private MachineState state = MachineState.NORMAL;
    private boolean instantRunDisabled = false;
    private String instanceToStaticDescPrefix;
    List<MethodNode> addedMethods = new ArrayList<MethodNode>();

    public IncrementalChangeVisitor(ClassNode classNode, List<ClassNode> parentNodes, ClassVisitor classVisitor) {
        super(classNode, parentNodes, classVisitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, 33, name + OVERRIDE_SUFFIX, signature, "java/lang/Object", new String[]{CHANGE_TYPE.getInternalName()});
        this.visitedClassName = name;
        this.visitedSuperName = superName;
        this.instanceToStaticDescPrefix = "(L" + this.visitedClassName + ";";
        MethodVisitor mv = super.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        super.visitField(4105, "$obsolete", "Z", null, null);
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (DISABLE_ANNOTATION_TYPE.getDescriptor().equals(desc)) {
            this.instantRunDisabled = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.instantRunDisabled || !IncrementalChangeVisitor.isAccessCompatibleWithInstantRun(access)) {
            return null;
        }
        if (name.equals("<clinit>")) {
            return null;
        }
        boolean isStatic = (access & 8) != 0;
        String newDesc = this.computeOverrideMethodDesc(desc, isStatic);
        access = 9;
        MethodNode method = IncrementalChangeVisitor.getMethodByNameInClass(name, desc, this.classNode);
        if (name.equals("<init>")) {
            Constructor constructor = ConstructorBuilder.build(this.visitedClassName, method);
            MethodVisitor original = super.visitMethod(access, constructor.args.name, constructor.args.desc, constructor.args.signature, exceptions);
            ISVisitor mv = new ISVisitor(original, access, constructor.args.name, constructor.args.desc, isStatic, true);
            constructor.args.accept((MethodVisitor)mv);
            original = super.visitMethod(access, constructor.body.name, constructor.body.desc, constructor.body.signature, exceptions);
            mv = new ISVisitor(original, access, constructor.body.name, newDesc, isStatic, true);
            constructor.body.accept((MethodVisitor)mv);
            this.addedMethods.add(constructor.args);
            this.addedMethods.add(constructor.body);
            return null;
        }
        String newName = isStatic ? this.computeOverrideMethodName(name, desc) : name;
        MethodVisitor original = super.visitMethod(access, newName, newDesc, signature, exceptions);
        return new ISVisitor(original, access, newName, newDesc, isStatic, false);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public void visitEnd() {
        this.addDispatchMethod();
    }

    private void addDispatchMethod() {
        int access = 129;
        Method m = new Method("access$dispatch", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
        MethodVisitor visitor = super.visitMethod(access, m.getName(), m.getDescriptor(), null, null);
        final GeneratorAdapter mv = new GeneratorAdapter(access, m, visitor);
        if (TRACING_ENABLED) {
            mv.push("Redirecting ");
            mv.loadArg(0);
            IncrementalChangeVisitor.trace(mv, 2);
        }
        ArrayList<MethodNode> allMethods = new ArrayList<MethodNode>();
        if (!this.instantRunDisabled) {
            allMethods.addAll(this.classNode.methods);
            allMethods.addAll(this.addedMethods);
        }
        final HashMap<String, MethodNode> methods = new HashMap<String, MethodNode>();
        for (MethodNode methodNode : allMethods) {
            if (methodNode.name.equals("<clinit>") || methodNode.name.equals("<init>") || !IncrementalChangeVisitor.isAccessCompatibleWithInstantRun(methodNode.access)) continue;
            methods.put(methodNode.name + "." + methodNode.desc, methodNode);
        }
        new StringSwitch(){

            @Override
            void visitString() {
                mv.visitVarInsn(25, 1);
            }

            @Override
            void visitCase(String methodName) {
                MethodNode methodNode = (MethodNode)methods.get(methodName);
                String name = methodNode.name;
                boolean isStatic = (methodNode.access & 8) != 0;
                String newDesc = IncrementalChangeVisitor.this.computeOverrideMethodDesc(methodNode.desc, isStatic);
                if (IncrementalVisitor.TRACING_ENABLED) {
                    IncrementalVisitor.trace(mv, "M: " + name + " P:" + newDesc);
                }
                Type[] args = Type.getArgumentTypes((String)newDesc);
                int argc = 0;
                for (Type t : args) {
                    mv.visitVarInsn(25, 2);
                    mv.push(argc);
                    mv.visitInsn(50);
                    ByteCodeUtils.unbox(mv, t);
                    ++argc;
                }
                mv.visitMethodInsn(184, IncrementalChangeVisitor.this.visitedClassName + IncrementalChangeVisitor.OVERRIDE_SUFFIX, isStatic ? IncrementalChangeVisitor.this.computeOverrideMethodName(name, methodNode.desc) : name, newDesc, false);
                Type ret = Type.getReturnType((String)methodNode.desc);
                if (ret.getSort() == 0) {
                    mv.visitInsn(1);
                } else {
                    mv.box(ret);
                }
                mv.visitInsn(176);
            }

            @Override
            void visitDefault() {
                this.writeMissingMessageWithHash(mv, IncrementalChangeVisitor.this.visitedClassName);
            }
        }.visit(mv, methods.keySet());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        super.visitEnd();
    }

    public static void main(String[] args) throws IOException {
        IncrementalVisitor.main(args, VISITOR_BUILDER);
    }

    private boolean isInSamePackage(String type) {
        if (type.charAt(0) == '[') {
            return false;
        }
        return this.getPackage(this.visitedClassName).equals(this.getPackage(type));
    }

    private String getPackage(String className) {
        int i = className.lastIndexOf(47);
        return i == -1 ? className : className.substring(0, i);
    }

    private boolean isAnAncestor(String className) {
        for (ClassNode parentNode : this.parentNodes) {
            if (!parentNode.name.equals(className)) continue;
            return true;
        }
        return false;
    }

    private String computeOverrideMethodDesc(String desc, boolean isStatic) {
        if (isStatic) {
            return desc;
        }
        return this.instanceToStaticDescPrefix + desc.substring(1);
    }

    private String computeOverrideMethodName(String name, String desc) {
        if (desc.startsWith(this.instanceToStaticDescPrefix) && !name.equals("init$args") && !name.equals("init$body")) {
            return METHOD_MANGLE_PREFIX + name;
        }
        return name;
    }

    public class ISVisitor
    extends GeneratorAdapter {
        private final boolean isStatic;
        private final boolean isConstructor;

        public ISVisitor(MethodVisitor mv, int access, String name, String desc, boolean isStatic, boolean isConstructor) {
            super(327680, mv, access, name, desc);
            this.isStatic = isStatic;
            this.isConstructor = isConstructor;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            FieldNode fieldNode;
            IncrementalVisitor.AccessRight accessRight = !owner.equals(IncrementalChangeVisitor.this.visitedClassName) ? IncrementalVisitor.AccessRight.PUBLIC : ((fieldNode = IncrementalChangeVisitor.this.getFieldByName(name)) == null ? IncrementalVisitor.AccessRight.PACKAGE_PRIVATE : IncrementalVisitor.AccessRight.fromNodeAccess(fieldNode.access));
            boolean handled = false;
            switch (opcode) {
                case 178: 
                case 179: {
                    handled = this.visitStaticFieldAccess(opcode, owner, name, desc, accessRight);
                    break;
                }
                case 180: 
                case 181: {
                    handled = this.visitFieldAccess(opcode, owner, name, desc, accessRight);
                    break;
                }
                default: {
                    System.out.println("Unhandled field opcode " + opcode);
                }
            }
            if (!handled) {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        private boolean visitFieldAccess(int opcode, String owner, String name, String desc, IncrementalVisitor.AccessRight accessRight) {
            boolean useReflection;
            boolean bl = useReflection = accessRight != IncrementalVisitor.AccessRight.PUBLIC;
            if (!useReflection) {
                boolean bl2 = useReflection = this.isConstructor && owner.equals(IncrementalChangeVisitor.this.visitedClassName);
            }
            if (useReflection) {
                switch (opcode) {
                    case 180: {
                        this.visitLdcInsn(Type.getType((String)("L" + owner + ";")));
                        this.push(name);
                        this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"Object getPrivateField(Object, Class, String)"));
                        ByteCodeUtils.unbox(this, Type.getType((String)desc));
                        break;
                    }
                    case 181: {
                        this.box(Type.getType((String)desc));
                        this.visitLdcInsn(Type.getType((String)("L" + owner + ";")));
                        this.push(name);
                        this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"void setPrivateField(Object, Object, Class, String)"));
                        break;
                    }
                    default: {
                        throw new RuntimeException("VisitFieldAccess called with wrong opcode " + opcode);
                    }
                }
                return true;
            }
            return false;
        }

        private boolean visitStaticFieldAccess(int opcode, String owner, String name, String desc, IncrementalVisitor.AccessRight accessRight) {
            if (accessRight != IncrementalVisitor.AccessRight.PUBLIC) {
                switch (opcode) {
                    case 178: {
                        this.visitLdcInsn(Type.getType((String)("L" + owner + ";")));
                        this.push(name);
                        this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"Object getStaticPrivateField(Class, String)"));
                        ByteCodeUtils.unbox(this, Type.getType((String)desc));
                        return true;
                    }
                    case 179: {
                        this.box(Type.getType((String)desc));
                        this.visitLdcInsn(Type.getType((String)("L" + owner + ";")));
                        this.push(name);
                        this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"void setStaticPrivateField(Object, Class, String)"));
                        return true;
                    }
                }
                throw new RuntimeException("VisitStaticFieldAccess called with wrong opcode " + opcode);
            }
            return false;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            boolean opcodeHandled = false;
            if (opcode == 183) {
                opcodeHandled = this.handleSpecialOpcode(owner, name, desc, itf);
            } else if (opcode == 182) {
                opcodeHandled = this.handleVirtualOpcode(owner, name, desc, itf);
            } else if (opcode == 184) {
                opcodeHandled = this.handleStaticOpcode(owner, name, desc, itf);
            }
            if (!opcodeHandled) {
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private boolean handleSpecialOpcode(String owner, String name, String desc, boolean itf) {
            if (name.equals("<init>")) {
                return this.handleConstructor(owner, name, desc);
            }
            if (owner.equals(IncrementalChangeVisitor.this.visitedClassName)) {
                String newDesc = IncrementalChangeVisitor.this.computeOverrideMethodDesc(desc, false);
                super.visitMethodInsn(184, owner + IncrementalChangeVisitor.OVERRIDE_SUFFIX, name, newDesc, itf);
                return true;
            }
            int arr = this.boxParametersToNewLocalArray(Type.getArgumentTypes((String)desc));
            this.push(name + "." + desc);
            this.loadLocal(arr);
            this.mv.visitMethodInsn(184, IncrementalChangeVisitor.this.visitedClassName, "access$super", IncrementalChangeVisitor.this.instanceToStaticDescPrefix + "Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", false);
            this.handleReturnType(desc);
            return true;
        }

        private boolean handleVirtualOpcode(String owner, String name, String desc, boolean itf) {
            IncrementalVisitor.AccessRight accessRight = this.getMethodAccessRight(owner, name, desc);
            if (accessRight == IncrementalVisitor.AccessRight.PUBLIC) {
                return false;
            }
            this.pushMethodRedirectArgumentsOnStack(name, desc);
            this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"Object invokeProtectedMethod(Object, Object[], Class[], String)"));
            this.handleReturnType(desc);
            return true;
        }

        private boolean handleStaticOpcode(String owner, String name, String desc, boolean itf) {
            IncrementalVisitor.AccessRight accessRight = this.getMethodAccessRight(owner, name, desc);
            if (accessRight == IncrementalVisitor.AccessRight.PUBLIC) {
                return false;
            }
            this.pushMethodRedirectArgumentsOnStack(name, desc);
            this.visitLdcInsn(Type.getType((String)("L" + owner + ";")));
            this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"Object invokeProtectedStaticMethod(Object[], Class[], String, Class)"));
            this.handleReturnType(desc);
            return true;
        }

        public void visitTypeInsn(int opcode, String s) {
            if (opcode == 187) {
                if (IncrementalChangeVisitor.this.state == MachineState.AFTER_NEW) {
                    throw new RuntimeException("Panic, two NEW opcode without a DUP");
                }
                if (IncrementalChangeVisitor.this.isInSamePackage(s)) {
                    IncrementalChangeVisitor.this.state = MachineState.AFTER_NEW;
                    return;
                }
            }
            super.visitTypeInsn(opcode, s);
        }

        public void visitInsn(int opcode) {
            if (opcode == 89 && IncrementalChangeVisitor.this.state == MachineState.AFTER_NEW) {
                IncrementalChangeVisitor.this.state = MachineState.NORMAL;
                return;
            }
            super.visitInsn(opcode);
        }

        private boolean handleConstructor(String owner, String name, String desc) {
            if (IncrementalChangeVisitor.this.isInSamePackage(owner)) {
                Type expectedType = Type.getType((String)("L" + owner + ";"));
                this.pushMethodRedirectArgumentsOnStack(name, desc);
                this.pop();
                this.visitLdcInsn(expectedType);
                this.invokeStatic(IncrementalVisitor.RUNTIME_TYPE, Method.getMethod((String)"Object newForClass(Object[], Class[], Class)"));
                this.checkCast(expectedType);
                ByteCodeUtils.unbox(this, expectedType);
                return true;
            }
            return false;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if ("this".equals(name)) {
                name = "$this";
            }
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitEnd() {
        }

        private IncrementalVisitor.AccessRight getMethodAccessRight(String owner, String name, String desc) {
            IncrementalVisitor.AccessRight accessRight;
            if (owner.equals(IncrementalChangeVisitor.this.visitedClassName)) {
                MethodNode methodByName = IncrementalChangeVisitor.this.getMethodByName(name, desc);
                if (methodByName == null) {
                    return IncrementalVisitor.AccessRight.PROTECTED;
                }
                accessRight = IncrementalVisitor.AccessRight.fromNodeAccess(methodByName.access);
            } else {
                accessRight = IncrementalVisitor.AccessRight.PUBLIC;
            }
            return accessRight;
        }

        private void pushMethodRedirectArgumentsOnStack(String name, String desc) {
            Type[] parameterTypes = Type.getArgumentTypes((String)desc);
            int parameters = this.boxParametersToNewLocalArray(parameterTypes);
            this.loadLocal(parameters);
            this.pushParameterTypesOnStack(parameterTypes);
            this.push(name);
        }

        private void pushParameterTypesOnStack(Type[] parameterTypes) {
            this.push(parameterTypes.length);
            this.newArray(Type.getType(Class.class));
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.dup();
                this.push(i);
                switch (parameterTypes[i].getSort()) {
                    case 9: 
                    case 10: {
                        this.visitLdcInsn(parameterTypes[i]);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.push(parameterTypes[i]);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected parameter type " + parameterTypes[i]);
                    }
                }
                this.arrayStore(Type.getType(Class.class));
            }
        }

        private void handleReturnType(String desc) {
            Type ret = Type.getReturnType((String)desc);
            if (ret.getSort() == 0) {
                this.pop();
            } else {
                ByteCodeUtils.unbox(this, ret);
            }
        }

        private int boxParametersToNewLocalArray(Type[] parameterTypes) {
            int parameters = this.newLocal(Type.getType((String)"[Ljava/lang.Object;"));
            this.push(parameterTypes.length);
            this.newArray(Type.getType(Object.class));
            this.storeLocal(parameters);
            for (int i = parameterTypes.length - 1; i >= 0; --i) {
                this.loadLocal(parameters);
                this.swap(parameterTypes[i], Type.getType(Object.class));
                this.push(i);
                this.swap(parameterTypes[i], Type.INT_TYPE);
                this.box(parameterTypes[i]);
                this.arrayStore(Type.getType(Object.class));
            }
            return parameters;
        }
    }

    private static enum MachineState {
        NORMAL,
        AFTER_NEW;

    }
}

