/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.ToolingRegistryProvider;
import com.android.build.gradle.tasks.Lint;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.w3c.dom.Document;

public class LintGradleProject
extends com.android.tools.lint.detector.api.Project {
    protected AndroidVersion mMinSdkVersion;
    protected AndroidVersion mTargetSdkVersion;

    private LintGradleProject(LintGradleClient client, File dir, File referenceDir, File manifest) {
        super((LintClient)client, dir, referenceDir);
        this.mGradleProject = true;
        this.mMergeManifests = true;
        this.mDirectLibraries = Lists.newArrayList();
        if (manifest != null) {
            this.readManifest(manifest);
        }
    }

    public static Pair<LintGradleProject, List<File>> create(LintGradleClient client, AndroidProject project, Variant variant, Project gradleProject) {
        assert (!Lint.MODEL_LIBRARIES);
        File dir = gradleProject.getProjectDir();
        AppGradleProject lintProject = new AppGradleProject(client, dir, dir, project, variant);
        ArrayList customRules = Lists.newArrayList();
        File appLintJar = new File(gradleProject.getBuildDir(), "lint" + File.separatorChar + "lint.jar");
        if (appLintJar.exists()) {
            customRules.add(appLintJar);
        }
        HashSet libraries = Sets.newHashSet();
        Dependencies dependencies = variant.getMainArtifact().getCompileDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            lintProject.addDirectLibrary(LintGradleProject.createLibrary(client, library, libraries, customRules));
        }
        return Pair.of((Object)((Object)lintProject), (Object)customRules);
    }

    protected void initialize() {
    }

    protected void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document != null) {
                    this.readManifest(document);
                }
            }
            catch (IOException e) {
                this.mClient.log((Throwable)e, "Could not read manifest %1$s", new Object[]{manifest});
            }
        }
    }

    public boolean isGradleProject() {
        return true;
    }

    protected static boolean dependsOn(Dependencies dependencies, String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!LintGradleProject.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    protected static boolean dependsOn(AndroidLibrary library, String artifact) {
        File bundle;
        if ("com.android.support:support-v4".equals(artifact) ? library.getJarFile().getName().startsWith("support-v4-") : "com.android.support:appcompat-v7".equals(artifact) && (bundle = library.getBundle()).getName().startsWith("appcompat-v7-")) {
            return true;
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            if (!LintGradleProject.dependsOn(dependency, artifact)) continue;
            return true;
        }
        return false;
    }

    void addDirectLibrary(com.android.tools.lint.detector.api.Project project) {
        this.mDirectLibraries.add(project);
    }

    private static LibraryProject createLibrary(LintGradleClient client, AndroidLibrary library, Set<AndroidLibrary> seen, List<File> customRules) {
        seen.add(library);
        File dir = library.getFolder();
        LibraryProject project = new LibraryProject(client, dir, dir, library);
        File ruleJar = library.getLintJar();
        if (ruleJar.exists()) {
            customRules.add(ruleJar);
        }
        for (AndroidLibrary dependent : library.getLibraryDependencies()) {
            if (seen.contains(dependent)) continue;
            project.addDirectLibrary(LintGradleProject.createLibrary(client, dependent, seen, customRules));
        }
        return project;
    }

    private static class JavaLibraryProject
    extends LintGradleProject {
        private JavaLibrary mLibrary;

        private JavaLibraryProject(LintGradleClient client, File dir, File referenceDir, JavaLibrary library) {
            super(client, dir, referenceDir, null);
            this.mLibrary = library;
            this.mReportIssues = false;
        }

        public boolean isLibrary() {
            return true;
        }

        public List<File> getManifestFiles() {
            return Collections.emptyList();
        }

        public List<File> getProguardFiles() {
            return Collections.emptyList();
        }

        public List<File> getResourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getAssetFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getTestSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            if (!includeProvided && this.mLibrary.isProvided()) {
                return Collections.emptyList();
            }
            if (this.mJavaLibraries == null) {
                this.mJavaLibraries = Collections.singletonList(this.mLibrary.getJarFile());
            }
            return this.mJavaLibraries;
        }
    }

    static class ProjectSearch {
        public final Map<AndroidProject, com.android.tools.lint.detector.api.Project> appProjects = Maps.newHashMap();
        public final Map<AndroidLibrary, com.android.tools.lint.detector.api.Project> libraryProjects = Maps.newHashMap();
        public final Map<MavenCoordinates, com.android.tools.lint.detector.api.Project> libraryProjectsByCoordinate = Maps.newHashMap();
        public final Map<String, com.android.tools.lint.detector.api.Project> namedProjects = Maps.newHashMap();
        public final Map<JavaLibrary, com.android.tools.lint.detector.api.Project> javaLibraryProjects = Maps.newHashMap();
        public final Map<MavenCoordinates, com.android.tools.lint.detector.api.Project> javaLibraryProjectsByCoordinate = Maps.newHashMap();
        public final Map<Project, AndroidProject> gradleProjects = Maps.newHashMap();
        public final List<File> customViewRuleJars = Lists.newArrayList();
        private Set<Object> mSeen = Sets.newHashSet();

        public ProjectSearch() {
            assert (Lint.MODEL_LIBRARIES);
        }

        private static AndroidProject createAndroidProject(LintGradleClient client, Project gradleProject) {
            PluginContainer pluginContainer = gradleProject.getPlugins();
            for (Plugin p : pluginContainer) {
                if (!(p instanceof ToolingRegistryProvider)) continue;
                ToolingModelBuilderRegistry registry = ((ToolingRegistryProvider)p).getModelBuilderRegistry();
                String modelName = AndroidProject.class.getName();
                ToolingModelBuilder builder = registry.getBuilder(modelName);
                assert (builder.canBuild(modelName)) : modelName;
                return (AndroidProject)builder.buildAll(modelName, gradleProject);
            }
            return null;
        }

        private AndroidProject getAndroidProject(LintGradleClient client, Project gradleProject) {
            AndroidProject androidProject = this.gradleProjects.get(gradleProject);
            if (androidProject == null && (androidProject = ProjectSearch.createAndroidProject(client, gradleProject)) != null) {
                this.gradleProjects.put(gradleProject, androidProject);
            }
            return androidProject;
        }

        public com.android.tools.lint.detector.api.Project getProject(LintGradleClient client, Project gradleProject, String variantName) {
            JavaPluginConvention convention;
            AndroidProject androidProject = this.getAndroidProject(client, gradleProject);
            if (androidProject != null) {
                for (Variant variant : androidProject.getVariants()) {
                    if (!variantName.equals(variant.getName())) continue;
                    return this.getProject(client, androidProject, variant, gradleProject);
                }
                assert (false) : variantName;
            }
            if ((convention = (JavaPluginConvention)gradleProject.getConvention().getPlugin(JavaPluginConvention.class)) == null) {
                return null;
            }
            SourceSetContainer sourceSets = convention.getSourceSets();
            if (sourceSets != null) {
                final ArrayList sources = Lists.newArrayList();
                final ArrayList classes = Lists.newArrayList();
                final ArrayList libs = Lists.newArrayList();
                final ArrayList tests = Lists.newArrayList();
                for (SourceSet sourceSet : sourceSets) {
                    SourceSetOutput output;
                    SourceDirectorySet javaSrc;
                    if (sourceSet.getName().equals("test")) {
                        javaSrc = sourceSet.getJava();
                        if (javaSrc == null) continue;
                        tests.addAll(javaSrc.getSrcDirs());
                        continue;
                    }
                    javaSrc = sourceSet.getJava();
                    if (javaSrc != null) {
                        sources.addAll(javaSrc.getSrcDirs());
                    }
                    if ((output = sourceSet.getOutput()) != null) {
                        classes.add(output.getClassesDir());
                    }
                    libs.addAll(sourceSet.getCompileClasspath().getFiles());
                }
                File dir = gradleProject.getProjectDir();
                final ArrayList directLibraries = Lists.newArrayList();
                com.android.tools.lint.detector.api.Project project = new com.android.tools.lint.detector.api.Project((LintClient)client, dir, dir){

                    protected void initialize() {
                        this.mGradleProject = true;
                        this.mMergeManifests = true;
                        this.mDirectLibraries = directLibraries;
                        this.mJavaSourceFolders = sources;
                        this.mJavaClassFolders = classes;
                        this.mJavaLibraries = libs;
                        this.mTestSourceFolders = tests;
                    }

                    public boolean isGradleProject() {
                        return true;
                    }

                    public boolean isAndroidProject() {
                        return false;
                    }

                    public IAndroidTarget getBuildTarget() {
                        return null;
                    }
                };
                ConfigurationContainer configurations = gradleProject.getConfigurations();
                Configuration compile = configurations.getByName("compile");
                if (compile != null) {
                    for (Dependency dependency : compile.getDependencies()) {
                        String version;
                        String name;
                        String group;
                        MavenCoordinatesImpl coordinates;
                        com.android.tools.lint.detector.api.Project javaLib;
                        if (dependency instanceof ProjectDependency) {
                            com.android.tools.lint.detector.api.Project lintProject;
                            Project p = ((ProjectDependency)dependency).getDependencyProject();
                            if (p == null || (lintProject = this.getProject(client, p.getName(), p, variantName)) == null) continue;
                            directLibraries.add(lintProject);
                            continue;
                        }
                        if (!(dependency instanceof ExternalDependency) || (javaLib = this.javaLibraryProjectsByCoordinate.get(coordinates = new MavenCoordinatesImpl(group = dependency.getGroup(), name = dependency.getName(), version = dependency.getVersion()))) == null) continue;
                        directLibraries.add(javaLib);
                    }
                }
                return project;
            }
            return null;
        }

        public com.android.tools.lint.detector.api.Project getProject(LintGradleClient client, AndroidProject project, Variant variant, Project gradleProject) {
            com.android.tools.lint.detector.api.Project cached = this.appProjects.get(project);
            if (cached != null) {
                return cached;
            }
            this.mSeen.add(project);
            File dir = gradleProject.getProjectDir();
            AppGradleProject lintProject = new AppGradleProject(client, dir, dir, project, variant);
            this.appProjects.put(project, lintProject);
            File appLintJar = new File(gradleProject.getBuildDir(), "lint" + File.separatorChar + "lint.jar");
            if (appLintJar.exists()) {
                this.customViewRuleJars.add(appLintJar);
            }
            Dependencies dependencies = variant.getMainArtifact().getDependencies();
            for (AndroidLibrary library : dependencies.getLibraries()) {
                if (library.getProject() != null && gradleProject.findProject(library.getProject()) == gradleProject) continue;
                lintProject.addDirectLibrary(this.getLibrary(client, library, gradleProject, variant));
            }
            ArrayList processedProjects = null;
            for (String projectName : dependencies.getProjects()) {
                if (processedProjects == null) {
                    processedProjects = Lists.newArrayList();
                }
                processedProjects.add(projectName);
                com.android.tools.lint.detector.api.Project libLintProject = this.getProject(client, projectName, gradleProject, variant.getName());
                if (libLintProject == null) continue;
                lintProject.addDirectLibrary(libLintProject);
            }
            for (JavaLibrary library : dependencies.getJavaLibraries()) {
                String projectName = library.getProject();
                if (projectName != null) {
                    if (processedProjects != null && processedProjects.contains(projectName)) continue;
                    com.android.tools.lint.detector.api.Project libLintProject = this.getProject(client, projectName, gradleProject, variant.getName());
                    if (libLintProject != null) {
                        lintProject.addDirectLibrary(libLintProject);
                        continue;
                    }
                }
                lintProject.addDirectLibrary(this.getLibrary(client, library));
            }
            assert (dependencies.getProjects().isEmpty());
            return lintProject;
        }

        private com.android.tools.lint.detector.api.Project getProject(LintGradleClient client, String name, Project gradleProject, String variantName) {
            com.android.tools.lint.detector.api.Project project;
            com.android.tools.lint.detector.api.Project cached = this.namedProjects.get(name);
            if (cached != null) {
                return cached;
            }
            Project namedProject = gradleProject.findProject(name);
            if (namedProject != null && (project = this.getProject(client, namedProject, variantName)) != null) {
                this.namedProjects.put(name, project);
                return project;
            }
            return null;
        }

        private com.android.tools.lint.detector.api.Project getLibrary(LintGradleClient client, AndroidLibrary library, Project gradleProject, Variant variant) {
            com.android.tools.lint.detector.api.Project project;
            com.android.tools.lint.detector.api.Project cached = this.libraryProjects.get(library);
            if (cached != null) {
                return cached;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            cached = this.libraryProjectsByCoordinate.get(coordinates);
            if (cached != null) {
                return cached;
            }
            if (library.getProject() != null && (project = this.getProject(client, library.getProject(), gradleProject, variant.getName())) != null) {
                this.libraryProjects.put(library, project);
                return project;
            }
            this.mSeen.add(library);
            File dir = library.getFolder();
            LibraryProject project2 = new LibraryProject(client, dir, dir, library);
            this.libraryProjects.put(library, project2);
            this.libraryProjectsByCoordinate.put(coordinates, project2);
            File ruleJar = library.getLintJar();
            if (ruleJar.exists()) {
                this.customViewRuleJars.add(ruleJar);
            }
            for (AndroidLibrary dependent : library.getLibraryDependencies()) {
                project2.addDirectLibrary(this.getLibrary(client, dependent, gradleProject, variant));
            }
            return project2;
        }

        private com.android.tools.lint.detector.api.Project getLibrary(LintGradleClient client, JavaLibrary library) {
            com.android.tools.lint.detector.api.Project cached = this.javaLibraryProjects.get(library);
            if (cached != null) {
                return cached;
            }
            MavenCoordinates coordinates = library.getResolvedCoordinates();
            cached = this.javaLibraryProjectsByCoordinate.get(coordinates);
            if (cached != null) {
                return cached;
            }
            this.mSeen.add(library);
            File dir = library.getJarFile();
            JavaLibraryProject project = new JavaLibraryProject(client, dir, dir, library);
            this.javaLibraryProjects.put(library, project);
            this.javaLibraryProjectsByCoordinate.put(coordinates, project);
            for (JavaLibrary dependent : library.getDependencies()) {
                project.addDirectLibrary(this.getLibrary(client, dependent));
            }
            return project;
        }
    }

    private static class LibraryProject
    extends LintGradleProject {
        private AndroidLibrary mLibrary;

        private LibraryProject(LintGradleClient client, File dir, File referenceDir, AndroidLibrary library) {
            super(client, dir, referenceDir, library.getManifest());
            this.mLibrary = library;
            this.mReportIssues = false;
        }

        public boolean isLibrary() {
            return true;
        }

        public AndroidLibrary getGradleLibraryModel() {
            return this.mLibrary;
        }

        public Variant getCurrentVariant() {
            return null;
        }

        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifest = this.mLibrary.getManifest();
                this.mManifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                File proguardRules = this.mLibrary.getProguardRules();
                this.mProguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.mProguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                File folder = this.mLibrary.getResFolder();
                this.mResourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mResourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.mAssetFolders == null) {
                File folder = this.mLibrary.getAssetsFolder();
                this.mAssetFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mAssetFolders;
        }

        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getTestSourceFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            if (!includeProvided && this.mLibrary.isProvided()) {
                return Collections.emptyList();
            }
            if (this.mJavaLibraries == null) {
                this.mJavaLibraries = Stream.concat(Stream.of(this.mLibrary.getJarFile()), this.mLibrary.getLocalJars().stream()).filter(File::exists).collect(Collectors.toList());
            }
            return this.mJavaLibraries;
        }

        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    this.mSupportLib = LibraryProject.dependsOn(this.mLibrary, artifact);
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = LibraryProject.dependsOn(this.mLibrary, artifact);
                }
                return this.mAppCompat;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class AppGradleProject
    extends LintGradleProject {
        private AndroidProject mProject;
        private Variant mVariant;
        private List<SourceProvider> mProviders;
        private List<SourceProvider> mTestProviders;
        private static boolean sProvidedAvailable = true;

        private AppGradleProject(LintGradleClient client, File dir, File referenceDir, AndroidProject project, Variant variant) {
            super(client, dir, referenceDir, ((AndroidArtifactOutput)variant.getMainArtifact().getOutputs().iterator().next()).getGeneratedManifest());
            this.mProject = project;
            this.mVariant = variant;
        }

        public boolean isLibrary() {
            return this.mProject.isLibrary();
        }

        public AndroidProject getGradleProjectModel() {
            return this.mProject;
        }

        public Variant getCurrentVariant() {
            return this.mVariant;
        }

        private List<SourceProvider> getSourceProviders() {
            if (this.mProviders == null) {
                SourceProvider variantProvider;
                ArrayList providers = Lists.newArrayList();
                AndroidArtifact mainArtifact = this.mVariant.getMainArtifact();
                providers.add(this.mProject.getDefaultConfig().getSourceProvider());
                block0: for (String flavorName : this.mVariant.getProductFlavors()) {
                    for (ProductFlavorContainer flavor : this.mProject.getProductFlavors()) {
                        if (!flavorName.equals(flavor.getProductFlavor().getName())) continue;
                        providers.add(flavor.getSourceProvider());
                        continue block0;
                    }
                }
                SourceProvider multiProvider = mainArtifact.getMultiFlavorSourceProvider();
                if (multiProvider != null) {
                    providers.add(multiProvider);
                }
                String buildTypeName = this.mVariant.getBuildType();
                for (BuildTypeContainer buildType : this.mProject.getBuildTypes()) {
                    if (!buildTypeName.equals(buildType.getBuildType().getName())) continue;
                    providers.add(buildType.getSourceProvider());
                    break;
                }
                if ((variantProvider = mainArtifact.getVariantSourceProvider()) != null) {
                    providers.add(variantProvider);
                }
                this.mProviders = providers;
            }
            return this.mProviders;
        }

        private List<SourceProvider> getTestSourceProviders() {
            if (this.mTestProviders == null) {
                ArrayList providers = Lists.newArrayList();
                ProductFlavorContainer defaultConfig = this.mProject.getDefaultConfig();
                for (SourceProviderContainer extra : defaultConfig.getExtraSourceProviders()) {
                    String artifactName = extra.getArtifactName();
                    if (!"_android_test_".equals(artifactName)) continue;
                    providers.add(extra.getSourceProvider());
                }
                for (String flavorName : this.mVariant.getProductFlavors()) {
                    for (ProductFlavorContainer flavor : this.mProject.getProductFlavors()) {
                        if (!flavorName.equals(flavor.getProductFlavor().getName())) continue;
                        for (SourceProviderContainer extra : flavor.getExtraSourceProviders()) {
                            String artifactName = extra.getArtifactName();
                            if (!"_android_test_".equals(artifactName)) continue;
                            providers.add(extra.getSourceProvider());
                        }
                    }
                }
                String buildTypeName = this.mVariant.getBuildType();
                for (BuildTypeContainer buildType : this.mProject.getBuildTypes()) {
                    if (!buildTypeName.equals(buildType.getBuildType().getName())) continue;
                    for (SourceProviderContainer extra : buildType.getExtraSourceProviders()) {
                        String artifactName = extra.getArtifactName();
                        if (!"_android_test_".equals(artifactName)) continue;
                        providers.add(extra.getSourceProvider());
                    }
                }
                this.mTestProviders = providers;
            }
            return this.mTestProviders;
        }

        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                this.mManifestFiles = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    File manifestFile = provider.getManifestFile();
                    if (!manifestFile.exists()) continue;
                    this.mManifestFiles.add(manifestFile);
                }
            }
            return this.mManifestFiles;
        }

        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                this.mProguardFiles = flavor.getProguardFiles().stream().filter(File::exists).collect(Collectors.toList());
                try {
                    this.mProguardFiles.addAll(flavor.getConsumerProguardFiles().stream().filter(File::exists).collect(Collectors.toList()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.mProguardFiles;
        }

        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                this.mResourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection resDirs = provider.getResDirectories();
                    this.mResourceFolders.addAll(resDirs.stream().filter(File::exists).collect(Collectors.toList()));
                }
                this.mResourceFolders.addAll(this.mVariant.getMainArtifact().getGeneratedResourceFolders().stream().filter(File::exists).collect(Collectors.toList()));
            }
            return this.mResourceFolders;
        }

        public List<File> getAssetFolders() {
            if (this.mAssetFolders == null) {
                this.mAssetFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection dirs = provider.getAssetsDirectories();
                    this.mAssetFolders.addAll(dirs.stream().filter(File::exists).collect(Collectors.toList()));
                }
            }
            return this.mAssetFolders;
        }

        public List<File> getJavaSourceFolders() {
            if (this.mJavaSourceFolders == null) {
                this.mJavaSourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection srcDirs = provider.getJavaDirectories();
                    this.mJavaSourceFolders.addAll(srcDirs.stream().filter(File::exists).collect(Collectors.toList()));
                }
                this.mJavaSourceFolders.addAll(this.mVariant.getMainArtifact().getGeneratedSourceFolders().stream().filter(File::exists).collect(Collectors.toList()));
            }
            return this.mJavaSourceFolders;
        }

        public List<File> getTestSourceFolders() {
            if (this.mTestSourceFolders == null) {
                this.mTestSourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getTestSourceProviders()) {
                    this.mTestSourceFolders.addAll(provider.getJavaDirectories().stream().filter(File::exists).collect(Collectors.toList()));
                }
            }
            return this.mTestSourceFolders;
        }

        public List<File> getJavaClassFolders() {
            if (this.mJavaClassFolders == null) {
                this.mJavaClassFolders = new ArrayList(1);
                File outputClassFolder = this.mVariant.getMainArtifact().getClassesFolder();
                if (outputClassFolder.exists()) {
                    this.mJavaClassFolders.add(outputClassFolder);
                }
            }
            return this.mJavaClassFolders;
        }

        public List<File> getJavaLibraries(boolean includeProvided) {
            if (includeProvided) {
                if (this.mJavaLibraries == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getCompileDependencies();
                    Collection libs = dependencies.getJavaLibraries();
                    this.mJavaLibraries = Lists.newArrayListWithExpectedSize((int)libs.size());
                    for (JavaLibrary lib : libs) {
                        File jar = lib.getJarFile();
                        if (!jar.exists()) continue;
                        this.mJavaLibraries.add(jar);
                    }
                }
                return this.mJavaLibraries;
            }
            if (this.mNonProvidedJavaLibraries == null) {
                Dependencies dependencies = this.mVariant.getMainArtifact().getCompileDependencies();
                Collection libs = dependencies.getJavaLibraries();
                this.mNonProvidedJavaLibraries = Lists.newArrayListWithExpectedSize((int)libs.size());
                for (JavaLibrary lib : libs) {
                    File jar = lib.getJarFile();
                    if (!jar.exists()) continue;
                    if (sProvidedAvailable) {
                        try {
                            if (lib.isProvided()) {
                                continue;
                            }
                        }
                        catch (Throwable t) {
                            sProvidedAvailable = false;
                        }
                    }
                    this.mNonProvidedJavaLibraries.add(jar);
                }
            }
            return this.mNonProvidedJavaLibraries;
        }

        public String getPackage() {
            String packageName;
            if (this.mPackage == null && (packageName = this.mProject.getDefaultConfig().getProductFlavor().getApplicationId()) != null) {
                return packageName;
            }
            return this.mPackage;
        }

        public AndroidVersion getMinSdkVersion() {
            if (this.mMinSdkVersion == null) {
                ApiVersion minSdk = this.mVariant.getMergedFlavor().getMinSdkVersion();
                if (minSdk == null) {
                    ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                    minSdk = flavor.getMinSdkVersion();
                }
                this.mMinSdkVersion = minSdk != null ? LintUtils.convertVersion((ApiVersion)minSdk, (IAndroidTarget[])this.mClient.getTargets()) : super.getMinSdkVersion();
            }
            return this.mMinSdkVersion;
        }

        public AndroidVersion getTargetSdkVersion() {
            if (this.mTargetSdkVersion == null) {
                ApiVersion targetSdk = this.mVariant.getMergedFlavor().getTargetSdkVersion();
                if (targetSdk == null) {
                    ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                    targetSdk = flavor.getTargetSdkVersion();
                }
                this.mTargetSdkVersion = targetSdk != null ? LintUtils.convertVersion((ApiVersion)targetSdk, (IAndroidTarget[])this.mClient.getTargets()) : super.getTargetSdkVersion();
            }
            return this.mTargetSdkVersion;
        }

        public int getBuildSdk() {
            String compileTarget = this.mProject.getCompileTarget();
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            if (version != null) {
                return version.getFeatureLevel();
            }
            return super.getBuildSdk();
        }

        public Boolean dependsOn(String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getCompileDependencies();
                    this.mSupportLib = AppGradleProject.dependsOn(dependencies, artifact);
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getCompileDependencies();
                    this.mAppCompat = AppGradleProject.dependsOn(dependencies, artifact);
                }
                return this.mAppCompat;
            }
            return super.dependsOn(artifact);
        }
    }
}

