/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.api.Project;

public class ProguardFiles {
    public static final ImmutableSet<String> DEFAULT_PROGUARD_WHITELIST = ImmutableSet.of((Object)"proguard-android.txt", (Object)"proguard-android-optimize.txt");

    public static File getDefaultProguardFile(String name, Project project) {
        if (!DEFAULT_PROGUARD_WHITELIST.contains((Object)name)) {
            throw new IllegalArgumentException("User supplied default proguard base extension name is unsupported. Valid values are: " + DEFAULT_PROGUARD_WHITELIST);
        }
        return FileUtils.join((File)project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "proguard-files", name + "-" + "2.2.2"});
    }

    public static void extractBundledProguardFiles(Project project) throws IOException {
        for (String name : DEFAULT_PROGUARD_WHITELIST) {
            File defaultProguardFile = ProguardFiles.getDefaultProguardFile(name, project);
            if (defaultProguardFile.isFile()) continue;
            ProguardFiles.extractBundledProguardFile(name, defaultProguardFile);
        }
    }

    public static void extractBundledProguardFile(String name, File proguardFile) throws IOException {
        Files.createParentDirs((File)proguardFile);
        URL proguardURL = ProguardFiles.class.getResource(name);
        URLConnection urlConnection = proguardURL.openConnection();
        urlConnection.setUseCaches(false);
        try (InputStream is = urlConnection.getInputStream();){
            Files.asByteSink((File)proguardFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom(is);
        }
    }
}

