/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitCommitCompareInfo {
    private static final Logger LOG = Logger.getInstance(GitCommitCompareInfo.class);
    private final Map<GitRepository, Pair<List<GitCommit>, List<GitCommit>>> myInfo = new HashMap<GitRepository, Pair<List<GitCommit>, List<GitCommit>>>();
    private final Map<GitRepository, Collection<Change>> myTotalDiff = new HashMap<GitRepository, Collection<Change>>();
    private final InfoType myInfoType;

    public GitCommitCompareInfo() {
        this(InfoType.BOTH);
    }

    public GitCommitCompareInfo(@NotNull InfoType infoType) {
        this.myInfoType = infoType;
    }

    public void put(@NotNull GitRepository repository, @NotNull Pair<List<GitCommit>, List<GitCommit>> commits) {
        this.myInfo.put(repository, commits);
    }

    public void put(@NotNull GitRepository repository, @NotNull Collection<Change> totalDiff) {
        this.myTotalDiff.put(repository, totalDiff);
    }

    @NotNull
    public List<GitCommit> getHeadToBranchCommits(@NotNull GitRepository repo) {
        return (List)this.getCompareInfo(repo).getFirst();
    }

    @NotNull
    public List<GitCommit> getBranchToHeadCommits(@NotNull GitRepository repo) {
        return (List)this.getCompareInfo(repo).getSecond();
    }

    @NotNull
    private Pair<List<GitCommit>, List<GitCommit>> getCompareInfo(@NotNull GitRepository repo) {
        Pair<List<GitCommit>, List<GitCommit>> pair = this.myInfo.get(repo);
        if (pair == null) {
            LOG.error("Compare info not found for repository " + repo);
            return Pair.create(Collections.emptyList(), Collections.emptyList());
        }
        return pair;
    }

    @NotNull
    public Collection<GitRepository> getRepositories() {
        return this.myInfo.keySet();
    }

    public boolean isEmpty() {
        return this.myInfo.isEmpty();
    }

    public InfoType getInfoType() {
        return this.myInfoType;
    }

    @NotNull
    public List<Change> getTotalDiff() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Collection<Change> changeCollection : this.myTotalDiff.values()) {
            changes.addAll(changeCollection);
        }
        return changes;
    }

    public static enum InfoType {
        BOTH,
        HEAD_TO_BRANCH,
        BRANCH_TO_HEAD;

    }
}

