/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateConfigurable;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateEnvironment
implements UpdateEnvironment {
    private final Project myProject;
    private final GitVcsSettings mySettings;
    @NotNull
    private final GitPlatformFacade myPlatformFacade;

    public GitUpdateEnvironment(@NotNull Project project, @NotNull GitVcsSettings settings) {
        this.myProject = project;
        this.mySettings = settings;
        this.myPlatformFacade = (GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class);
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(@NotNull FilePath[] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> sequentialUpdatesContextRef) throws ProcessCanceledException {
        Set<VirtualFile> roots = GitUtil.gitRoots(Arrays.asList(filePaths));
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(this.myProject);
        GitUpdateProcess gitUpdateProcess = new GitUpdateProcess(this.myProject, this.myPlatformFacade, progressIndicator, GitUtil.getRepositoriesFromRoots(repositoryManager, roots), updatedFiles, true);
        boolean result = gitUpdateProcess.update(this.mySettings.getUpdateType()).isSuccess();
        return new GitUpdateSession(result);
    }

    public boolean validateOptions(Collection<FilePath> filePaths) {
        for (FilePath p : filePaths) {
            if (GitUtil.isUnderGit(p)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return new GitUpdateConfigurable(this.mySettings);
    }
}

