/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.RefsModel;
import git4idea.GitPlatformFacade;
import git4idea.config.GitVcsSettings;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitLogBranchOperationsActionGroup
extends ActionGroup
implements DumbAware {
    private static final int MAX_BRANCH_GROUPS = 2;

    public GitLogBranchOperationsActionGroup() {
        this.setPopup(false);
    }

    public boolean hideIfNoVisibleChildren() {
        return true;
    }

    @NotNull
    public AnAction[] getChildren(AnActionEvent e) {
        if (e == null) {
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogUi logUI = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || log == null || logUI == null) {
            return AnAction.EMPTY_ARRAY;
        }
        List commits = log.getSelectedCommits();
        if (commits.size() != 1) {
            return AnAction.EMPTY_ARRAY;
        }
        CommitId commit = (CommitId)commits.get(0);
        GitRepositoryManager repositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        final GitRepository root = (GitRepository)repositoryManager.getRepositoryForRoot(commit.getRoot());
        if (root == null) {
            return AnAction.EMPTY_ARRAY;
        }
        VcsLogDataPack dataPack = logUI.getDataPack();
        Collection allVcsRefs = ((RefsModel)dataPack.getRefs()).refsToCommit(commit.getHash(), commit.getRoot());
        List vcsRefs = ContainerUtil.filter((Collection)allVcsRefs, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                if (ref.getType() == GitRefManager.LOCAL_BRANCH) {
                    return !ref.getName().equals(root.getCurrentBranchName());
                }
                return ref.getType() == GitRefManager.REMOTE_BRANCH;
            }
        });
        VcsLogProvider provider = (VcsLogProvider)dataPack.getLogProviders().get(root.getRoot());
        if (provider != null) {
            VcsLogRefManager refManager = provider.getReferenceManager();
            Comparator comparator = refManager.getLabelsOrderComparator();
            ContainerUtil.sort((List)vcsRefs, (Comparator)comparator);
        }
        if (vcsRefs.isEmpty()) {
            return AnAction.EMPTY_ARRAY;
        }
        GitVcsSettings settings = ((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)).getSettings(project);
        boolean showBranchesPopup = vcsRefs.size() > 2;
        ArrayList<AnAction> branchActionGroups = new ArrayList<AnAction>();
        for (VcsRef ref : vcsRefs) {
            branchActionGroups.add(GitLogBranchOperationsActionGroup.createBranchGroup(project, ref, root, repositoryManager, settings, showBranchesPopup));
        }
        DefaultActionGroup branchesGroup = new DefaultActionGroup("Branches", branchActionGroups);
        branchesGroup.setPopup(showBranchesPopup);
        return new AnAction[]{branchesGroup};
    }

    @NotNull
    private static AnAction createBranchGroup(@NotNull Project project, @NotNull VcsRef ref, @NotNull GitRepository repository, @NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings settings, boolean showBranchesPopup) {
        List<GitRepository> allRepositories = repositoryManager.getRepositories();
        boolean isSyncBranch = settings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC && allRepositories.size() > 1 && GitLogBranchOperationsActionGroup.branchInAllRepositories(allRepositories, ref);
        boolean isLocal = ref.getType() == GitRefManager.LOCAL_BRANCH;
        ArrayList<Object> actions = new ArrayList<Object>(3);
        ActionGroup singleRepoActions = GitLogBranchOperationsActionGroup.createBranchActions(project, Collections.singletonList(repository), ref, repository, isLocal);
        singleRepoActions.setPopup(false);
        actions.add(singleRepoActions);
        if (isSyncBranch) {
            actions.add(Separator.getInstance());
            ActionGroup allReposActions = GitLogBranchOperationsActionGroup.createBranchActions(project, allRepositories, ref, repository, isLocal);
            allReposActions.getTemplatePresentation().setText("In All Repositories");
            allReposActions.setPopup(true);
            actions.add(allReposActions);
        }
        String text = showBranchesPopup ? ref.getName() : "Branch '" + ref.getName() + "'";
        DefaultActionGroup group = new DefaultActionGroup(actions);
        group.getTemplatePresentation().setText(text, false);
        group.setPopup(true);
        return group;
    }

    private static boolean branchInAllRepositories(@NotNull List<GitRepository> repositories, final @NotNull VcsRef branches) {
        return ContainerUtil.and(repositories, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return repository.getBranches().findBranchByName(branches.getName()) != null;
            }
        });
    }

    @NotNull
    private static ActionGroup createBranchActions(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull VcsRef ref, @NotNull GitRepository selectedRepository, boolean isLocal) {
        if (isLocal) {
            return new GitBranchPopupActions.LocalBranchActions(project, repositories, ref.getName(), selectedRepository);
        }
        return new GitBranchPopupActions.RemoteBranchActions(project, repositories, ref.getName(), selectedRepository);
    }
}

