/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class GitStashUtils {
    private GitStashUtils() {
    }

    public static void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, Consumer<StashInfo> consumer) {
        GitStashUtils.loadStashStack(project, root, Charset.forName(GitConfigUtil.getLogEncoding(project, root)), consumer);
    }

    public static void loadStashStack(@NotNull Project project, @NotNull VirtualFile root, @NotNull Charset charset, Consumer<StashInfo> consumer) {
        String out;
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.STASH.readLockingCommand());
        h.setSilent(true);
        h.addParameters("list");
        try {
            h.setCharset(charset);
            out = h.run();
        }
        catch (VcsException e) {
            GitUIUtil.showOperationError(project, e, h.printableCommandLine());
            return;
        }
        StringScanner s = new StringScanner(out);
        while (s.hasMoreData()) {
            consumer.consume((Object)new StashInfo(s.boundedToken(':'), s.boundedToken(':'), s.line().trim()));
        }
    }
}

