/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitPlatformFacade;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final GitPlatformFacade myPlatformFacade;
    @NotNull
    protected final ChangeListManagerEx myChangeManager;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final String myStashMessage;
    protected GitConflictResolver.Params myParams;

    @NotNull
    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage, @NotNull GitVcsSettings.UpdateChangesPolicy saveMethod) {
        if (saveMethod == GitVcsSettings.UpdateChangesPolicy.SHELVE) {
            return new GitShelveChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
        }
        return new GitStashChangesSaver(project, platformFacade, git, progressIndicator, stashMessage);
    }

    protected GitChangesSaver(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull String stashMessage) {
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.myStashMessage = stashMessage;
        this.myChangeManager = platformFacade.getChangeListManager(project);
    }

    public void saveLocalChanges(@Nullable Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    public void notifyLocalChangesAreNotRestored() {
        if (this.wereChangesSaved()) {
            LOG.info("Update is incomplete, changes are not restored");
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were not restored", "Before update your uncommitted changes were saved to <a href='saver'>" + this.getSaverName() + "</a>.<br/>" + "Update is not complete, you have unresolved merges in your working tree<br/>" + "Resolve conflicts, complete update and restore changes manually.", (NotificationListener)new ShowSavedChangesNotificationListener());
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<VirtualFile> var1) throws VcsException;

    public abstract void load();

    public abstract boolean wereChangesSaved();

    public abstract String getSaverName();

    @NotNull
    public abstract String getOperationName();

    public abstract void showSavedChanges();

    @NotNull
    protected static String getConflictRightPanelTitle() {
        return "Changes from remote";
    }

    @NotNull
    protected static String getConflictLeftPanelTitle() {
        return "Your uncommitted changes";
    }

    protected class ShowSavedChangesNotificationListener
    implements NotificationListener {
        protected ShowSavedChangesNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("saver")) {
                GitChangesSaver.this.showSavedChanges();
            }
        }
    }
}

