/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.project.Project;
import git4idea.GitPlatformFacade;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryManager
extends AbstractRepositoryManager<GitRepository> {
    @NotNull
    private final GitPlatformFacade myPlatformFacade;
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile GitRebaseSpec myOngoingRebaseSpec;

    public GitRepositoryManager(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        super(vcsRepositoryManager, platformFacade.getVcs(project), ".git");
        this.myProject = project;
        this.myPlatformFacade = platformFacade;
    }

    public boolean isSyncEnabled() {
        return this.myPlatformFacade.getSettings(this.myProject).getSyncSetting() == DvcsSyncSettings.Value.SYNC && !new GitMultiRootBranchConfig(this.getRepositories()).diverged();
    }

    @NotNull
    public List<GitRepository> getRepositories() {
        return this.getRepositories(GitRepository.class);
    }

    @Nullable
    public GitRebaseSpec getOngoingRebaseSpec() {
        GitRebaseSpec rebaseSpec = this.myOngoingRebaseSpec;
        return rebaseSpec != null && rebaseSpec.isValid() ? rebaseSpec : null;
    }

    public boolean hasOngoingRebase() {
        return this.getOngoingRebaseSpec() != null;
    }

    public void setOngoingRebaseSpec(@Nullable GitRebaseSpec ongoingRebaseSpec) {
        this.myOngoingRebaseSpec = ongoingRebaseSpec != null && ongoingRebaseSpec.isValid() ? ongoingRebaseSpec : null;
    }
}

