/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepoInfo {
    @Nullable
    private final GitLocalBranch myCurrentBranch;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @NotNull
    private final Set<GitRemote> myRemotes;
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;
    @NotNull
    private final Set<GitBranchTrackInfo> myBranchTrackInfos;

    public GitRepoInfo(@Nullable GitLocalBranch currentBranch, @Nullable String currentRevision, @NotNull Repository.State state, @NotNull Collection<GitRemote> remotes, @NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches, @NotNull Collection<GitBranchTrackInfo> branchTrackInfos) {
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myState = state;
        this.myRemotes = new LinkedHashSet<GitRemote>(remotes);
        this.myLocalBranches = new LinkedHashMap<GitLocalBranch, Hash>(localBranches);
        this.myRemoteBranches = new LinkedHashMap<GitRemoteBranch, Hash>(remoteBranches);
        this.myBranchTrackInfos = new LinkedHashSet<GitBranchTrackInfo>(branchTrackInfos);
    }

    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myCurrentBranch;
    }

    @NotNull
    public Collection<GitRemote> getRemotes() {
        return this.myRemotes;
    }

    @NotNull
    public Map<GitLocalBranch, Hash> getLocalBranchesWithHashes() {
        return this.myLocalBranches;
    }

    @NotNull
    public Map<GitRemoteBranch, Hash> getRemoteBranchesWithHashes() {
        return this.myRemoteBranches;
    }

    @Deprecated
    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        return this.myRemoteBranches.keySet();
    }

    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.myBranchTrackInfos;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @NotNull
    public Repository.State getState() {
        return this.myState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRepoInfo info = (GitRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (this.myCurrentBranch != null ? !this.myCurrentBranch.equals(info.myCurrentBranch) : info.myCurrentBranch != null) {
            return false;
        }
        if (!this.myRemotes.equals(info.myRemotes)) {
            return false;
        }
        if (!this.myBranchTrackInfos.equals(info.myBranchTrackInfos)) {
            return false;
        }
        if (!GitRepoInfo.areEqual(this.myLocalBranches, info.myLocalBranches)) {
            return false;
        }
        return GitRepoInfo.areEqual(this.myRemoteBranches, info.myRemoteBranches);
    }

    public int hashCode() {
        int result = this.myCurrentBranch != null ? this.myCurrentBranch.hashCode() : 0;
        result = 31 * result + (this.myCurrentRevision != null ? this.myCurrentRevision.hashCode() : 0);
        result = 31 * result + this.myState.hashCode();
        result = 31 * result + this.myRemotes.hashCode();
        result = 31 * result + this.myLocalBranches.hashCode();
        result = 31 * result + this.myRemoteBranches.hashCode();
        result = 31 * result + this.myBranchTrackInfos.hashCode();
        return result;
    }

    public String toString() {
        return String.format("GitRepoInfo{current=%s, remotes=%s, localBranches=%s, remoteBranches=%s, trackInfos=%s}", this.myCurrentBranch, this.myRemotes, this.myLocalBranches, this.myRemoteBranches, this.myBranchTrackInfos);
    }

    private static <T extends GitBranch> boolean areEqual(Map<T, Hash> c1, Map<T, Hash> c2) {
        THashSet set1 = new THashSet(c1.entrySet(), (TObjectHashingStrategy)new BranchesComparingStrategy());
        THashSet set2 = new THashSet(c2.entrySet(), (TObjectHashingStrategy)new BranchesComparingStrategy());
        return set1.equals((Object)set2);
    }

    private static class BranchesComparingStrategy
    implements TObjectHashingStrategy<Map.Entry<? extends GitBranch, Hash>> {
        private BranchesComparingStrategy() {
        }

        public int computeHashCode(@NotNull Map.Entry<? extends GitBranch, Hash> branchEntry) {
            return 31 * branchEntry.getKey().getName().hashCode() + branchEntry.getValue().hashCode();
        }

        public boolean equals(@NotNull Map.Entry<? extends GitBranch, Hash> b1, @NotNull Map.Entry<? extends GitBranch, Hash> b2) {
            if (b1 == b2) {
                return true;
            }
            if (b1.getClass() != b2.getClass()) {
                return false;
            }
            return b1.getKey().getName().equals(b2.getKey().getName()) && b2.getValue().equals(b2.getValue());
        }
    }
}

