/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.util.containers.ContainerUtil;
import git4idea.push.GitPushRepoResult;
import git4idea.repo.GitRepository;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GroupedPushResult {
    @NotNull
    final Map<GitRepository, GitPushRepoResult> successful;
    @NotNull
    final Map<GitRepository, GitPushRepoResult> errors;
    @NotNull
    final Map<GitRepository, GitPushRepoResult> rejected;
    @NotNull
    final Map<GitRepository, GitPushRepoResult> customRejected;

    private GroupedPushResult(@NotNull Map<GitRepository, GitPushRepoResult> successful, @NotNull Map<GitRepository, GitPushRepoResult> errors, @NotNull Map<GitRepository, GitPushRepoResult> rejected, @NotNull Map<GitRepository, GitPushRepoResult> customRejected) {
        this.successful = successful;
        this.errors = errors;
        this.rejected = rejected;
        this.customRejected = customRejected;
    }

    @NotNull
    static GroupedPushResult group(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        HashMap successful = ContainerUtil.newHashMap();
        HashMap rejected = ContainerUtil.newHashMap();
        HashMap customRejected = ContainerUtil.newHashMap();
        HashMap errors = ContainerUtil.newHashMap();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : results.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult result = entry.getValue();
            if (result.getType() == GitPushRepoResult.Type.REJECTED_NO_FF) {
                rejected.put(repository, result);
                continue;
            }
            if (result.getType() == GitPushRepoResult.Type.ERROR) {
                errors.put(repository, result);
                continue;
            }
            if (result.getType() == GitPushRepoResult.Type.REJECTED_OTHER) {
                customRejected.put(repository, result);
                continue;
            }
            successful.put(repository, result);
        }
        return new GroupedPushResult(successful, errors, rejected, customRejected);
    }
}

