/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDefineRemoteDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitDefineRemoteDialog.class);
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final Git myGit;
    @NotNull
    private final JTextField myRemoteName;
    @NotNull
    private final JTextField myRemoteUrl;

    GitDefineRemoteDialog(@NotNull GitRepository repository, @NotNull Git git) {
        super(repository.getProject());
        this.myRepository = repository;
        this.myGit = git;
        this.myRemoteName = new JTextField("origin", 20);
        this.myRemoteUrl = new JTextField(20);
        this.setTitle("Define Remote");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel defineRemoteComponent = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultAnchor(21).setDefaultInsets(4, 10, 0, 0);
        defineRemoteComponent.add((Component)new JBLabel("Name:"), gb.nextLine().next().anchor(13));
        defineRemoteComponent.add((Component)this.myRemoteName, gb.next());
        defineRemoteComponent.add((Component)new JBLabel("URL: "), gb.nextLine().next().anchor(13).insets(0, 10, 4, 0));
        defineRemoteComponent.add((Component)this.myRemoteUrl, gb.next());
        return defineRemoteComponent;
    }

    @NotNull
    String getRemoteName() {
        return StringUtil.notNullize((String)this.myRemoteName.getText()).trim();
    }

    @NotNull
    String getRemoteUrl() {
        return StringUtil.notNullize((String)this.myRemoteUrl.getText()).trim();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRemoteUrl;
    }

    protected void doOKAction() {
        String url;
        String name = this.getRemoteName();
        String error = this.validateRemoteUnderModal(name, url = this.getRemoteUrl());
        if (error != null) {
            LOG.warn(String.format("Invalid remote. Name: [%s], URL: [%s], error: %s", name, url, error));
            Messages.showErrorDialog((Project)this.myRepository.getProject(), (String)error, (String)"Invalid Remote");
        } else {
            super.doOKAction();
        }
    }

    @Nullable
    private String validateRemoteUnderModal(@NotNull String name, final @NotNull String url) throws ProcessCanceledException {
        if (url.isEmpty()) {
            return "URL can't be empty";
        }
        if (!GitRefNameValidator.getInstance().checkInput(name)) {
            return "Remote name contains illegal characters";
        }
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<String, ProcessCanceledException>(){

            public String compute() throws ProcessCanceledException {
                GitCommandResult result = GitDefineRemoteDialog.this.myGit.lsRemote(GitDefineRemoteDialog.this.myRepository.getProject(), VfsUtilCore.virtualToIoFile((VirtualFile)GitDefineRemoteDialog.this.myRepository.getRoot()), url);
                return !result.success() ? "Remote URL test failed: " + result.getErrorOutputAsHtmlString() : null;
            }
        }, "Checking URL...", true, this.myRepository.getProject());
    }
}

