/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<GitFileRevision> {
    private static final Logger LOG = Logger.getInstance(GitDiffFromHistoryHandler.class);
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    public GitDiffFromHistoryHandler(@NotNull Project project) {
        super(project);
        this.myGit = (Git)ServiceManager.getService((Project)project, Git.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        GitFileRevision rev = (GitFileRevision)revision;
        Collection<String> parents = rev.getParents();
        if (parents.size() < 2) {
            super.showDiffForOne(e, project, filePath, previousRevision, revision);
        } else {
            this.showDiffForMergeCommit(e, filePath, rev, parents);
        }
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull GitFileRevision rev1, @Nullable GitFileRevision rev2) throws VcsException {
        GitRepository repository = this.getRepository(path);
        String hash1 = rev1.getHash();
        String hash2 = rev2 != null ? rev2.getHash() : null;
        return ContainerUtil.newArrayList(GitChangeUtils.getDiff(repository.getProject(), repository.getRoot(), hash1, hash2, Collections.singletonList(path)));
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull GitFileRevision rev) throws VcsException {
        GitRepository repository = this.getRepository(path);
        return ContainerUtil.newArrayList((Iterable)GitChangeUtils.getRevisionChanges(repository.getProject(), repository.getRoot(), rev.getHash(), false, true, true).getChanges());
    }

    @NotNull
    protected String getPresentableName(@NotNull GitFileRevision revision) {
        return DvcsUtil.getShortHash((String)revision.getHash());
    }

    @NotNull
    private GitRepository getRepository(@NotNull FilePath path) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForFile(path);
        LOG.assertTrue(repository != null, (Object)("Repository is null for " + path));
        return repository;
    }

    private void showDiffForMergeCommit(final @NotNull AnActionEvent event, final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, @NotNull Collection<String> parents) {
        VcsHistorySession session = (VcsHistorySession)event.getData(VcsDataKeys.HISTORY_SESSION);
        List revisions = session != null ? session.getRevisionList() : null;
        this.checkIfFileWasTouchedAndFindParentsInBackground(filePath, rev, parents, revisions, new Consumer<MergeCommitPreCheckInfo>(){

            public void consume(MergeCommitPreCheckInfo info) {
                if (!info.wasFileTouched()) {
                    String message = String.format("There were no changes in %s in this merge commit, besides those which were made in both branches", filePath.getName());
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)GitDiffFromHistoryHandler.this.myProject, (String)message, (MessageType)MessageType.INFO);
                }
                GitDiffFromHistoryHandler.this.showPopup(event, rev, filePath, info.getParents());
            }
        });
    }

    private void checkIfFileWasTouchedAndFindParentsInBackground(final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, final @NotNull Collection<String> parentHashes, final @Nullable List<VcsFileRevision> revisions, final @NotNull Consumer<MergeCommitPreCheckInfo> resultHandler) {
        new Task.Backgroundable(this.myProject, "Loading changes...", true){
            private MergeCommitPreCheckInfo myInfo;

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    GitRepository repository = GitDiffFromHistoryHandler.this.getRepository(filePath);
                    boolean fileTouched = GitDiffFromHistoryHandler.this.wasFileTouched(repository, rev);
                    Collection parents = GitDiffFromHistoryHandler.this.findParentRevisions(repository, rev, parentHashes, revisions);
                    this.myInfo = new MergeCommitPreCheckInfo(fileTouched, parents);
                }
                catch (VcsException e) {
                    String logMessage = "Error happened while executing git show " + rev + ":" + filePath;
                    GitDiffFromHistoryHandler.this.showError(e, logMessage);
                }
            }

            public void onSuccess() {
                if (this.myInfo != null) {
                    resultHandler.consume((Object)this.myInfo);
                }
            }
        }.queue();
    }

    @NotNull
    private Collection<GitFileRevision> findParentRevisions(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull Collection<String> parentHashes, @Nullable List<VcsFileRevision> revisions) throws VcsException {
        ArrayList<GitFileRevision> parents = new ArrayList<GitFileRevision>(parentHashes.size());
        for (String parentHash : parentHashes) {
            parents.add(this.createParentRevision(repository, currentRevision, parentHash, revisions));
        }
        return parents;
    }

    @NotNull
    private GitFileRevision createParentRevision(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull String parentHash, @Nullable List<VcsFileRevision> revisions) throws VcsException {
        FilePath currentRevisionPath;
        if (revisions != null) {
            for (VcsFileRevision revision : revisions) {
                if (!((GitFileRevision)revision).getHash().equals(parentHash)) continue;
                return (GitFileRevision)revision;
            }
        }
        if ((currentRevisionPath = currentRevision.getPath()).isDirectory()) {
            return this.makeRevisionFromHash(currentRevisionPath, parentHash);
        }
        Collection<Change> changes = GitChangeUtils.getDiff(this.myProject, repository.getRoot(), parentHash, currentRevision.getHash(), null);
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(currentRevisionPath)) continue;
            FilePath path = beforeRevision != null ? beforeRevision.getFile() : afterRevision.getFile();
            return this.makeRevisionFromHash(path, parentHash);
        }
        LOG.error(String.format("Could not find parent revision. Will use the path from parent revision. Current revision: %s, parent hash: %s", currentRevision, parentHash));
        return this.makeRevisionFromHash(currentRevisionPath, parentHash);
    }

    private void showPopup(@NotNull AnActionEvent event, @NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<GitFileRevision> parents) {
        ActionGroup parentActions = this.createActionGroup(rev, filePath, parents);
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Choose parent to compare", parentActions, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        GitDiffFromHistoryHandler.showPopupInBestPosition(popup, event, dataContext);
    }

    private static void showPopupInBestPosition(@NotNull ListPopup popup, @NotNull AnActionEvent event, @NotNull DataContext dataContext) {
        if (event.getInputEvent() instanceof MouseEvent) {
            if (!event.getPlace().equals("UpdatePopup")) {
                popup.show(new RelativePoint((MouseEvent)event.getInputEvent()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else {
            popup.showInBestPositionFor(dataContext);
        }
    }

    @NotNull
    private ActionGroup createActionGroup(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<GitFileRevision> parents) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(2);
        for (GitFileRevision parent : parents) {
            actions.add(this.createParentAction(rev, filePath, parent));
        }
        return new DefaultActionGroup((AnAction[])ArrayUtil.toObjectArray(actions, AnAction.class));
    }

    @NotNull
    private AnAction createParentAction(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull GitFileRevision parent) {
        return new ShowDiffWithParentAction(filePath, rev, parent);
    }

    @NotNull
    private GitFileRevision makeRevisionFromHash(@NotNull FilePath filePath, @NotNull String hash) {
        return new GitFileRevision(this.myProject, filePath, new GitRevisionNumber(hash));
    }

    private boolean wasFileTouched(@NotNull GitRepository repository, @NotNull GitFileRevision rev) throws VcsException {
        GitCommandResult result = this.myGit.show(repository, rev.getHash());
        if (result.success()) {
            return GitDiffFromHistoryHandler.isFilePresentInOutput(repository, rev.getPath(), result.getOutput());
        }
        throw new VcsException(result.getErrorOutputAsJoinedString());
    }

    private static boolean isFilePresentInOutput(@NotNull GitRepository repository, @NotNull FilePath path, @NotNull List<String> output) {
        String relativePath = GitDiffFromHistoryHandler.getRelativePath(repository, path);
        for (String line : output) {
            if (!line.startsWith("---") && !line.startsWith("+++") || !line.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull GitRepository repository, @NotNull FilePath path) {
        return FileUtil.getRelativePath((String)repository.getRoot().getPath(), (String)path.getPath(), (char)'/');
    }

    @NotNull
    private static String getRevisionDescription(@NotNull GitFileRevision parent) {
        String hash = DvcsUtil.getShortHash((String)parent.getHash());
        String message = parent.getCommitMessage();
        if (message != null) {
            int index = StringUtil.indexOfAny((String)message, (String)"\n\r");
            if (index != -1) {
                message = message.substring(0, index) + "...";
            }
            if (message.length() > 40) {
                message = message.substring(0, 35) + "...";
            }
            return hash + " - " + message;
        }
        return hash;
    }

    private class ShowDiffWithParentAction
    extends DumbAwareAction {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final GitFileRevision myRevision;
        @NotNull
        private final GitFileRevision myParentRevision;

        public ShowDiffWithParentAction(@NotNull FilePath filePath, @NotNull GitFileRevision rev, GitFileRevision parent) {
            super(GitDiffFromHistoryHandler.getRevisionDescription(parent), parent.getCommitMessage(), null);
            this.myFilePath = filePath;
            this.myRevision = rev;
            this.myParentRevision = parent;
        }

        public void actionPerformed(AnActionEvent e) {
            GitDiffFromHistoryHandler.this.doShowDiff(this.myFilePath, (VcsFileRevision)this.myParentRevision, (VcsFileRevision)this.myRevision);
        }
    }

    private static class MergeCommitPreCheckInfo {
        private final boolean myWasFileTouched;
        private final Collection<GitFileRevision> myParents;

        private MergeCommitPreCheckInfo(boolean touched, Collection<GitFileRevision> parents) {
            this.myWasFileTouched = touched;
            this.myParents = parents;
        }

        public boolean wasFileTouched() {
            return this.myWasFileTouched;
        }

        public Collection<GitFileRevision> getParents() {
            return this.myParents;
        }
    }
}

