/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.util.SystemInfo;
import git4idea.config.GitVersion;
import org.jetbrains.annotations.NotNull;

public enum GitVersionSpecialty {
    ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 1, 1));
        }
    }
    ,
    NEEDS_QUOTES_IN_STASH_NAME{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.getType().equals((Object)GitVersion.Type.CYGWIN);
        }
    }
    ,
    STARTED_USING_RAW_BODY_IN_FORMAT{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 2, 0));
        }
    }
    ,
    KNOWS_STATUS_PORCELAIN{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 0, 0));
        }
    }
    ,
    SUPPORTS_FETCH_PRUNE{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 7, 2));
        }
    }
    ,
    OLD_STYLE_OF_UNTRACKED_AND_LOCAL_CHANGES_WOULD_BE_OVERWRITTEN{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isOlderOrEqual(new GitVersion(1, 7, 1, 0));
        }
    }
    ,
    DOESNT_DEFINE_HOME_ENV_VAR{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return SystemInfo.isWindows && version.isOlderOrEqual(new GitVersion(1, 7, 0, 2));
        }
    }
    ,
    NO_WALK_UNSORTED{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 12, 1));
        }
    }
    ,
    SUPPORTS_FOLLOW_TAGS{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 8, 3, 0));
        }
    }
    ,
    CAN_OVERRIDE_GIT_CONFIG_FOR_COMMAND{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 7, 2, 0));
        }
    }
    ,
    FOLLOW_IS_BUGGY_IN_THE_LOG{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isOlderOrEqual(new GitVersion(1, 7, 2, 0));
        }
    }
    ,
    FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY{

        @Override
        public boolean existsIn(@NotNull GitVersion version) {
            return version.isLaterOrEqual(new GitVersion(1, 9, 0, 0));
        }
    };


    public abstract boolean existsIn(@NotNull GitVersion var1);
}

