/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitMessageWithFilesDetector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GitUntrackedFilesOverwrittenByOperationDetector
extends GitMessageWithFilesDetector {
    private static final Pattern OLD_UNTRACKED_FILES_PATTERN = Pattern.compile(".*Untracked working tree file '(.*)' would be overwritten by.*");
    private static final GitMessageWithFilesDetector.Event NEW_UNTRACKED_FILES_OVERWRITTEN_BY = new GitMessageWithFilesDetector.Event("The following untracked working tree files would be overwritten by", "Please move or remove them before");

    public GitUntrackedFilesOverwrittenByOperationDetector(VirtualFile root) {
        super(NEW_UNTRACKED_FILES_OVERWRITTEN_BY, root);
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        super.onLineAvailable(line, outputType);
        Matcher m = OLD_UNTRACKED_FILES_PATTERN.matcher(line);
        if (m.matches()) {
            this.myMessageDetected = true;
            this.myAffectedFiles.add(m.group(1));
        }
    }
}

