/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitTextHandler
extends GitHandler {
    private OSProcessHandler myHandler;
    private volatile boolean myIsDestroyed;
    private final Object myProcessStateLock = new Object();

    protected GitTextHandler(@NotNull Project project, @NotNull File directory, @NotNull GitCommand command) {
        super(project, directory, command);
    }

    protected GitTextHandler(Project project, VirtualFile vcsRoot, GitCommand command) {
        super(project, vcsRoot, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Process startProcess() throws ExecutionException {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            if (this.myIsDestroyed) {
                return null;
            }
            ProcessHandler processHandler = this.createProcess(this.myCommandLine);
            this.myHandler = (OSProcessHandler)processHandler;
            return this.myHandler.getProcess();
        }
    }

    @Override
    protected void startHandlingStreams() {
        if (this.myHandler == null) {
            return;
        }
        this.myHandler.addProcessListener(new ProcessListener(){

            public void startNotified(ProcessEvent event) {
            }

            public void processTerminated(ProcessEvent event) {
                int exitCode = event.getExitCode();
                try {
                    GitTextHandler.this.setExitCode(exitCode);
                    GitTextHandler.this.cleanupEnv();
                    GitTextHandler.this.processTerminated(exitCode);
                }
                finally {
                    GitTextHandler.this.listeners().processTerminated(exitCode);
                }
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                GitTextHandler.this.onTextAvailable(event.getText(), outputType);
            }
        });
        this.myHandler.startNotify();
    }

    protected abstract void processTerminated(int var1);

    protected abstract void onTextAvailable(String var1, Key var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyProcess() {
        Object object = this.myProcessStateLock;
        synchronized (object) {
            this.myIsDestroyed = true;
            if (this.myHandler != null) {
                this.myHandler.destroyProcess();
            }
        }
    }

    @Override
    protected void waitForProcess() {
        if (this.myHandler != null) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            while (!this.myHandler.waitFor(50L)) {
                try {
                    if (indicator == null) continue;
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    this.myHandler.destroyProcess();
                    throw pce;
                }
            }
        }
    }

    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        commandLine.setCharset(this.getCharset());
        return new MyOSProcessHandler(commandLine);
    }

    private static class MyOSProcessHandler
    extends OSProcessHandler {
        private MyOSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            super(commandLine);
        }

        @NotNull
        public Charset getCharset() {
            return this.myCharset;
        }

        protected boolean useNonBlockingRead() {
            return !Registry.is((String)"git.blocking.read");
        }
    }
}

