/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImpl;
import com.intellij.ide.passwordSafe.ui.PasswordSafePromptDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.AuthData;
import com.intellij.util.ObjectUtils;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.AuthDialog;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHttpAuthenticator;
import git4idea.remote.GitHttpAuthDataProvider;
import git4idea.remote.GitRememberedInputs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitHttpGuiAuthenticator
implements GitHttpAuthenticator {
    private static final Logger LOG = Logger.getInstance(GitHttpGuiAuthenticator.class);
    private static final Class<GitHttpAuthenticator> PASS_REQUESTER = GitHttpAuthenticator.class;
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myTitle;
    @NotNull
    private final Collection<String> myUrlsFromCommand;
    @Nullable
    private String myPassword;
    @Nullable
    private String myPasswordKey;
    @Nullable
    private String myUnifiedUrl;
    @Nullable
    private String myLogin;
    private boolean mySaveOnDisk;
    @Nullable
    private GitHttpAuthDataProvider myDataProvider;
    private boolean myWasCancelled;

    GitHttpGuiAuthenticator(@NotNull Project project, @NotNull GitCommand command, @NotNull Collection<String> url) {
        this.myProject = project;
        this.myTitle = "Git " + StringUtil.capitalize((String)command.name());
        this.myUrlsFromCommand = url;
    }

    @Override
    @NotNull
    public String askPassword(@NotNull String url) {
        LOG.debug("askPassword. url=" + url + ", passwordKnown=" + (this.myPassword != null) + ", wasCancelled=" + this.myWasCancelled);
        if (this.myPassword != null) {
            return this.myPassword;
        }
        if (this.myWasCancelled) {
            return "";
        }
        this.myUnifiedUrl = this.getUnifiedUrl(url);
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(this.getUnifiedUrl(url));
        if (authData != null && ((AuthData)authData.second).getPassword() != null) {
            String password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
            this.myPassword = password;
            LOG.debug("askPassword. dataProvider=" + this.getCurrentDataProviderName() + ", unifiedUrl= " + this.getUnifiedUrl(url) + ", login=" + ((AuthData)authData.second).getLogin() + ", passwordKnown=" + (password != null));
            return password;
        }
        this.myPasswordKey = this.getUnifiedUrl(url);
        String password = PasswordSafePromptDialog.askPassword((Project)this.myProject, (String)this.myTitle, (String)("Enter the password for " + this.getDisplayableUrl(url)), PASS_REQUESTER, (String)this.myPasswordKey, (boolean)false, null);
        LOG.debug("askPassword. Password was asked and returned: " + (password == null ? "NULL" : (password.isEmpty() ? "EMPTY" : "NOT EMPTY")));
        if (password == null) {
            this.myWasCancelled = true;
            return "";
        }
        this.myPassword = password;
        this.myDataProvider = new GitDefaultHttpAuthDataProvider();
        return password;
    }

    @Override
    @NotNull
    public String askUsername(@NotNull String url) {
        this.myUnifiedUrl = this.getUnifiedUrl(url);
        Pair<GitHttpAuthDataProvider, AuthData> authData = this.findBestAuthData(this.getUnifiedUrl(url));
        String login = null;
        String password = null;
        if (authData != null) {
            login = ((AuthData)authData.second).getLogin();
            password = ((AuthData)authData.second).getPassword();
            this.myDataProvider = (GitHttpAuthDataProvider)authData.first;
        }
        LOG.debug("askUsername. dataProvider=" + this.getCurrentDataProviderName() + ", unifiedUrl= " + this.getUnifiedUrl(url) + ", login=" + login + ", passwordKnown=" + (password != null));
        if (login != null && password != null) {
            this.myPassword = password;
            return login;
        }
        AuthDialog dialog = this.showAuthDialog(this.getDisplayableUrl(url), login);
        LOG.debug("askUsername. Showed dialog:" + (dialog == null ? "NULL" : (dialog.isOK() ? "OK" : "Cancel")));
        if (dialog == null || !dialog.isOK()) {
            this.myWasCancelled = true;
            return "";
        }
        this.myPassword = dialog.getPassword();
        this.myLogin = dialog.getUsername();
        this.mySaveOnDisk = dialog.isRememberPassword();
        this.myPasswordKey = GitHttpGuiAuthenticator.makeKey(this.myUnifiedUrl, this.myLogin);
        return this.myLogin;
    }

    @Nullable
    private AuthDialog showAuthDialog(final String url, final String login) {
        final Ref dialog = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                dialog.set((Object)new AuthDialog(GitHttpGuiAuthenticator.this.myProject, GitHttpGuiAuthenticator.this.myTitle, "Enter credentials for " + url, login, null, true));
                ((AuthDialog)dialog.get()).show();
            }
        }, ModalityState.any());
        return (AuthDialog)dialog.get();
    }

    @Override
    public void saveAuthData() {
        if (this.myUnifiedUrl != null && this.myLogin != null) {
            GitRememberedInputs.getInstance().addUrl(this.myUnifiedUrl, this.myLogin);
        }
        if (this.myPasswordKey != null && this.myPassword != null) {
            PasswordSafeImpl passwordSafe = (PasswordSafeImpl)PasswordSafe.getInstance();
            try {
                passwordSafe.getMemoryProvider().storePassword(this.myProject, PASS_REQUESTER, this.myPasswordKey, this.myPassword);
                if (this.mySaveOnDisk) {
                    passwordSafe.getMasterKeyProvider().storePassword(this.myProject, PASS_REQUESTER, this.myPasswordKey, this.myPassword);
                }
            }
            catch (MasterPasswordUnavailableException masterPasswordUnavailableException) {
            }
            catch (PasswordSafeException e) {
                LOG.error("Couldn't remember password for " + this.myPasswordKey, (Throwable)e);
            }
        }
    }

    @Override
    public void forgetPassword() {
        LOG.debug("forgetPassword. dataProvider=" + this.getCurrentDataProviderName() + ", unifiedUrl=" + this.myUnifiedUrl);
        if (this.myDataProvider != null && this.myUnifiedUrl != null) {
            this.myDataProvider.forgetPassword(this.myUnifiedUrl);
        }
    }

    @Nullable
    private String getCurrentDataProviderName() {
        return this.myDataProvider == null ? null : this.myDataProvider.getClass().getName();
    }

    @Override
    public boolean wasCancelled() {
        return this.myWasCancelled;
    }

    @NotNull
    private String getDisplayableUrl(@Nullable String urlFromGit) {
        return !StringUtil.isEmptyOrSpaces((String)urlFromGit) ? urlFromGit : this.findPresetHttpUrl();
    }

    @NotNull
    private String getUnifiedUrl(@Nullable String urlFromGit) {
        return GitHttpGuiAuthenticator.changeHttpsToHttp(StringUtil.isEmptyOrSpaces((String)urlFromGit) ? this.findPresetHttpUrl() : urlFromGit);
    }

    @NotNull
    private String findPresetHttpUrl() {
        return (String)ObjectUtils.chooseNotNull((Object)ContainerUtil.find(this.myUrlsFromCommand, (Condition)new Condition<String>(){

            public boolean value(String url) {
                String scheme = (String)UriUtil.splitScheme((String)url).getFirst();
                return scheme.startsWith("http");
            }
        }), (Object)ContainerUtil.getFirstItem(this.myUrlsFromCommand));
    }

    @NotNull
    private static String changeHttpsToHttp(@NotNull String url) {
        String prefix = "https";
        if (url.startsWith(prefix)) {
            return "http" + url.substring(prefix.length());
        }
        return url;
    }

    @Nullable
    private Pair<GitHttpAuthDataProvider, AuthData> findBestAuthData(@NotNull String url) {
        Pair candidate = null;
        for (GitHttpAuthDataProvider provider : this.getProviders()) {
            AuthData data = provider.getAuthData(url);
            if (data == null) continue;
            Pair pair = Pair.create((Object)provider, (Object)data);
            if (data.getPassword() != null) {
                return pair;
            }
            if (candidate != null) continue;
            candidate = pair;
        }
        return candidate;
    }

    @NotNull
    private List<GitHttpAuthDataProvider> getProviders() {
        ArrayList providers = ContainerUtil.newArrayList();
        providers.add(new GitDefaultHttpAuthDataProvider());
        providers.addAll(Arrays.asList(GitHttpAuthDataProvider.EP_NAME.getExtensions()));
        return providers;
    }

    @NotNull
    private static String makeKey(@NotNull String url, @Nullable String login) {
        if (login == null) {
            return url;
        }
        Couple pair = UriUtil.splitScheme((String)url);
        String scheme = (String)pair.getFirst();
        if (!StringUtil.isEmpty((String)scheme)) {
            return scheme + "://" + login + "@" + (String)pair.getSecond();
        }
        return login + "@" + url;
    }

    public class GitDefaultHttpAuthDataProvider
    implements GitHttpAuthDataProvider {
        @Override
        @Nullable
        public AuthData getAuthData(@NotNull String url) {
            String userName = this.getUsername(url);
            String key = GitHttpGuiAuthenticator.makeKey(url, userName);
            PasswordSafe passwordSafe = PasswordSafe.getInstance();
            try {
                String password = passwordSafe.getPassword(GitHttpGuiAuthenticator.this.myProject, PASS_REQUESTER, key);
                return new AuthData(StringUtil.notNullize((String)userName), password);
            }
            catch (PasswordSafeException e) {
                LOG.info("Couldn't get the password for key [" + key + "]", (Throwable)e);
                return null;
            }
        }

        @Nullable
        private String getUsername(@NotNull String url) {
            return GitRememberedInputs.getInstance().getUserNameForUrl(url);
        }

        @Override
        public void forgetPassword(@NotNull String url) {
            String key = GitHttpGuiAuthenticator.this.myPasswordKey != null ? GitHttpGuiAuthenticator.this.myPasswordKey : GitHttpGuiAuthenticator.makeKey(url, this.getUsername(url));
            LOG.debug("forgetPassword. key=" + key);
            try {
                PasswordSafe.getInstance().removePassword(GitHttpGuiAuthenticator.this.myProject, PASS_REQUESTER, key);
            }
            catch (PasswordSafeException e) {
                LOG.info("Couldn't forget the password for " + GitHttpGuiAuthenticator.this.myPasswordKey);
            }
        }
    }
}

