/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitCommit;
import git4idea.GitPlatformFacade;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitDeleteBranchOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitDeleteBranchOperation.class);
    private final String myBranchName;

    GitDeleteBranchOperation(@NotNull Project project, GitPlatformFacade facade, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String branchName) {
        super(project, facade, git, uiHandler, repositories);
        this.myBranchName = branchName;
    }

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitBranchNotMergedToUpstreamDetector notMergedToUpstreamDetector;
            GitSimpleEventDetector notFullyMergedDetector;
            GitRepository repository = this.next();
            GitCommandResult result = this.myGit.branchDelete(repository, this.myBranchName, false, notFullyMergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.BRANCH_NOT_FULLY_MERGED), notMergedToUpstreamDetector = new GitBranchNotMergedToUpstreamDetector());
            if (result.success()) {
                GitDeleteBranchOperation.refresh(repository);
                this.markSuccessful(repository);
                continue;
            }
            if (notFullyMergedDetector.hasHappened()) {
                Collection<GitRepository> remainingRepositories;
                boolean forceDelete;
                String baseBranch = notMergedToUpstreamDetector.getBaseBranch();
                if (baseBranch == null) {
                    baseBranch = (String)this.myCurrentHeads.get(repository);
                }
                if (forceDelete = this.showNotFullyMergedDialog(this.myBranchName, baseBranch, remainingRepositories = this.getRemainingRepositories())) {
                    GitCompoundResult compoundResult = this.forceDelete(this.myBranchName, remainingRepositories);
                    if (compoundResult.totalSuccess()) {
                        GitRepository[] remainingRepositoriesArray = (GitRepository[])ArrayUtil.toObjectArray(remainingRepositories, GitRepository.class);
                        this.markSuccessful(remainingRepositoriesArray);
                        GitDeleteBranchOperation.refresh(remainingRepositoriesArray);
                        continue;
                    }
                    this.fatalError(this.getErrorTitle(), compoundResult.getErrorOutputWithReposIndication());
                    return;
                }
                if (this.wereSuccessful()) {
                    this.showFatalErrorDialogWithRollback(this.getErrorTitle(), "This branch is not fully merged to " + baseBranch + ".");
                }
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(this.getErrorTitle(), result.getErrorOutputAsJoinedString());
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
        }
    }

    private static void refresh(GitRepository ... repositories) {
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    @Override
    protected void rollback() {
        GitCompoundResult result = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult res = this.myGit.branchCreate(repository, this.myBranchName);
            result.append(repository, res);
            GitDeleteBranchOperation.refresh(repository);
        }
        if (!result.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback of branch deletion", result.getErrorOutputWithReposIndication());
        }
    }

    @NotNull
    private String getErrorTitle() {
        return String.format("Branch %s wasn't deleted", this.myBranchName);
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        return String.format("Deleted branch <b><code>%s</code></b>", this.myBranchName);
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return "However branch deletion has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>You may rollback (recreate " + this.myBranchName + " in these roots) not to let branches diverge.";
    }

    @Override
    @NotNull
    protected String getOperationName() {
        return "branch deletion";
    }

    @NotNull
    private GitCompoundResult forceDelete(@NotNull String branchName, @NotNull Collection<GitRepository> possibleFailedRepositories) {
        GitCompoundResult compoundResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : possibleFailedRepositories) {
            GitCommandResult res = this.myGit.branchDelete(repository, branchName, true, new GitLineHandlerListener[0]);
            compoundResult.append(repository, res);
        }
        return compoundResult;
    }

    private boolean showNotFullyMergedDialog(@NotNull String unmergedBranch, @NotNull String baseBranch, @NotNull Collection<GitRepository> repositories) {
        List<String> mergedToBranches = this.getMergedToBranches(unmergedBranch);
        HashMap<GitRepository, List<GitCommit>> history = new HashMap<GitRepository, List<GitCommit>>();
        for (GitRepository repository : this.getRepositories()) {
            if (repositories.contains(repository)) {
                history.put(repository, this.getUnmergedCommits(repository, unmergedBranch, baseBranch));
                continue;
            }
            history.put(repository, Collections.emptyList());
        }
        return this.myUiHandler.showBranchIsNotFullyMergedDialog(this.myProject, history, unmergedBranch, mergedToBranches, baseBranch);
    }

    @NotNull
    private List<GitCommit> getUnmergedCommits(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String baseBranch) {
        return this.myGit.history(repository, baseBranch + ".." + branchName);
    }

    @NotNull
    private List<String> getMergedToBranches(String branchName) {
        List<Object> mergedToBranches = null;
        for (GitRepository repository : this.getRemainingRepositories()) {
            List<String> branches = this.getMergedToBranches(repository, branchName);
            if (mergedToBranches == null) {
                mergedToBranches = branches;
                continue;
            }
            mergedToBranches = new ArrayList(ContainerUtil.intersection(mergedToBranches, branches));
        }
        return mergedToBranches != null ? mergedToBranches : new ArrayList();
    }

    @NotNull
    private List<String> getMergedToBranches(@NotNull GitRepository repository, @NotNull String branchName) {
        String tip = this.tip(repository, branchName);
        if (tip == null) {
            return Collections.emptyList();
        }
        return this.branchContainsCommit(repository, tip, branchName);
    }

    @Nullable
    private String tip(GitRepository repository, @NotNull String branchName) {
        GitCommandResult result = this.myGit.tip(repository, branchName);
        if (result.success() && result.getOutput().size() == 1) {
            return result.getOutput().get(0).trim();
        }
        LOG.info("Failed to get [git rev-list -1] for branch [" + branchName + "]. " + result);
        return null;
    }

    @NotNull
    private List<String> branchContainsCommit(@NotNull GitRepository repository, @NotNull String tip, @NotNull String branchName) {
        GitCommandResult result = this.myGit.branchContains(repository, tip);
        if (result.success()) {
            ArrayList<String> branches = new ArrayList<String>();
            for (String s : result.getOutput()) {
                if ((s = s.trim()).startsWith("*")) {
                    s = s.substring(2);
                }
                if (s.equals(branchName)) continue;
                branches.add(s);
            }
            return branches;
        }
        LOG.info("Failed to get [git branch --contains] for hash [" + tip + "]. " + result);
        return Collections.emptyList();
    }

    private static class GitBranchNotMergedToUpstreamDetector
    implements GitLineHandlerListener {
        private static final Pattern PATTERN = Pattern.compile(".*'(.*)', even though it is merged to.*");
        @Nullable
        private String myBaseBranch;

        private GitBranchNotMergedToUpstreamDetector() {
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myBaseBranch = matcher.group(1);
            }
        }

        public void processTerminated(int exitCode) {
        }

        public void startFailed(Throwable exception) {
        }

        @Nullable
        public String getBaseBranch() {
            return this.myBaseBranch;
        }
    }
}

