/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchesCollection {
    public static final GitBranchesCollection EMPTY = new GitBranchesCollection(Collections.emptyMap(), Collections.emptyMap());
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;

    public GitBranchesCollection(@NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches) {
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        return Collections.unmodifiableCollection(this.myLocalBranches.keySet());
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        return Collections.unmodifiableCollection(this.myRemoteBranches.keySet());
    }

    @Nullable
    public Hash getHash(@NotNull GitBranch branch) {
        if (branch instanceof GitLocalBranch) {
            return this.myLocalBranches.get(branch);
        }
        if (branch instanceof GitRemoteBranch) {
            return this.myRemoteBranches.get(branch);
        }
        return null;
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        return GitBranchesCollection.findByName(this.myLocalBranches.keySet(), name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        GitLocalBranch branch = GitBranchesCollection.findByName(this.myLocalBranches.keySet(), name);
        return branch != null ? branch : GitBranchesCollection.findByName(this.myRemoteBranches.keySet(), name);
    }

    @Nullable
    private static <T extends GitBranch> T findByName(Collection<T> branches, final @NotNull String name) {
        return (T)((GitBranch)ContainerUtil.find(branches, (Condition)new Condition<T>(){

            public boolean value(T branch) {
                return name.equals(((GitReference)branch).getName());
            }
        }));
    }
}

