/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.ui.ChangesBrowserWithRollback;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitPlatformFacade myFacade;
    @NotNull
    private final ProgressIndicator myProgressIndicator;

    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull GitPlatformFacade facade, @NotNull Git git, @NotNull ProgressIndicator indicator) {
        this.myProject = project;
        this.myGit = git;
        this.myFacade = facade;
        this.myProgressIndicator = indicator;
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(final @NotNull String title, final @NotNull String message, final @NotNull String rollbackProposal) {
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder description = new StringBuilder();
                if (!StringUtil.isEmptyOrSpaces((String)message)) {
                    description.append(message).append("<br/>");
                }
                description.append(rollbackProposal);
                ok.set(0 == DialogManager.showOkCancelDialog(GitBranchUiHandlerImpl.this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final @NotNull String operationName, final @NotNull Collection<GitRepository> repositories) {
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, description, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                    GitConflictResolver.Params params = new GitConflictResolver.Params().setMergeDescription(String.format("The following files have unresolved conflicts. You need to resolve them before %s.", operationName)).setErrorNotificationTitle("Unresolved files remain.");
                    new GitConflictResolver(GitBranchUiHandlerImpl.this.myProject, GitBranchUiHandlerImpl.this.myGit, GitBranchUiHandlerImpl.this.myFacade, GitUtil.getRootsFromRepositories(repositories), params).merge();
                }
            }
        });
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(final @NotNull String operationName, final @NotNull String rollbackProposal) {
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String description = String.format("<html>You have to resolve all merge conflicts before %s.<br/>%s</html>", operationName, rollbackProposal);
                ok.set(0 == DialogManager.showOkCancelDialog(GitBranchUiHandlerImpl.this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(@NotNull String operationName, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, relativePaths, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(@NotNull String operationName, @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        return GitUntrackedFilesHelper.showUntrackedFilesDialogWithRollback(this.myProject, operationName, rollbackProposal, root, relativePaths);
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        return this.myProgressIndicator;
    }

    @Override
    public int showSmartOperationDialog(@NotNull Project project, @NotNull List<Change> changes, @NotNull Collection<String> paths, @NotNull String operation, @Nullable String forceButtonTitle) {
        Object fileBrowser = !changes.isEmpty() ? new ChangesBrowserWithRollback(project, changes) : new GitSimplePathsBrowser(project, paths);
        return GitSmartOperationDialog.showAndGetAnswer(this.myProject, (JComponent)fileBrowser, operation, forceButtonTitle);
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(@NotNull Project project, final @NotNull Map<GitRepository, List<GitCommit>> history, final @NotNull String unmergedBranch, final @NotNull List<String> mergedToBranches, final @NotNull String baseBranch) {
        final AtomicBoolean forceDelete = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                forceDelete.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(GitBranchUiHandlerImpl.this.myProject, history, unmergedBranch, mergedToBranches, baseBranch));
            }
        });
        return forceDelete.get();
    }

    @NotNull
    private static String unmergedFilesErrorTitle(@NotNull String operationName) {
        return "Can't " + operationName + " because of unmerged files";
    }

    @NotNull
    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        return "You have to <a href='resolve'>resolve</a> all merge conflicts before " + operationName + ".<br/>" + "After resolving conflicts you also probably would want to commit your files to the current branch.";
    }
}

