/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUnstashDialog;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitUnstash
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.getString("unstash.action.name");
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isFreezedWithNotification("Can not unstash changes now")) {
            return;
        }
        GitUnstashDialog.showUnstashDialog(project, gitRoots, defaultRoot);
    }

    @Override
    protected boolean executeFinalTasksSynchronously() {
        return false;
    }
}

