/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRepositoryAction
extends DumbAwareAction {
    final List<TransactionRunnable> myDelayedTasks = new ArrayList<TransactionRunnable>();

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myDelayedTasks.clear();
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs vcs = GitVcs.getInstance(project);
        List<VirtualFile> roots = GitRepositoryAction.getGitRoots(project, vcs);
        if (roots == null) {
            return;
        }
        VirtualFile defaultRoot = GitRepositoryAction.getDefaultRoot(project, roots, (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY));
        HashSet<VirtualFile> affectedRoots = new HashSet<VirtualFile>();
        String actionName = this.getActionName();
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        try {
            this.perform(project, roots, defaultRoot, affectedRoots, exceptions);
        }
        catch (VcsException ex) {
            exceptions.add(ex);
        }
        if (this.executeFinalTasksSynchronously()) {
            this.runFinalTasks(project, vcs, affectedRoots, actionName, exceptions);
        }
    }

    @NotNull
    private static VirtualFile getDefaultRoot(@NotNull Project project, @NotNull List<VirtualFile> roots, @Nullable VirtualFile[] vFiles) {
        GitRepository currentRepository;
        if (vFiles != null) {
            for (VirtualFile file : vFiles) {
                VirtualFile root = GitUtil.gitRootOrNull(file);
                if (root == null) continue;
                return root;
            }
        }
        return (currentRepository = GitBranchUtil.getCurrentRepository(project)) != null ? currentRepository.getRoot() : roots.get(0);
    }

    protected final void runFinalTasks(final @NotNull Project project, final @NotNull GitVcs vcs, final @NotNull Set<VirtualFile> affectedRoots, final @NotNull String actionName, final @NotNull List<VcsException> exceptions) {
        VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])((VirtualFile[])ArrayUtil.toObjectArray(affectedRoots, VirtualFile.class)));
        LocalFileSystem.getInstance().refreshFiles(affectedRoots, true, true, new Runnable(){

            @Override
            public void run() {
                VcsFileUtil.markFilesDirty((Project)project, (Collection)affectedRoots);
                for (TransactionRunnable task : GitRepositoryAction.this.myDelayedTasks) {
                    task.run(exceptions);
                }
                GitRepositoryAction.this.myDelayedTasks.clear();
                vcs.showErrors(exceptions, actionName);
            }
        });
    }

    protected boolean executeFinalTasksSynchronously() {
        return true;
    }

    protected static boolean isRebasing(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (files != null) {
                for (VirtualFile file : files) {
                    GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
                    if (!GitRepositoryAction.isRebasing((GitRepository)manager.getRepositoryForFile(file))) continue;
                    return true;
                }
            }
            if (GitRepositoryAction.isRebasing(GitBranchUtil.getCurrentRepository(project))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isRebasing(@Nullable GitRepository repository) {
        return repository != null && repository.getState() == Repository.State.REBASING;
    }

    @Nullable
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) {
        List<VirtualFile> roots;
        try {
            roots = GitUtil.getGitRoots(project, vcs);
        }
        catch (VcsException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)GitBundle.getString("repository.action.missing.roots.title"));
            return null;
        }
        return roots;
    }

    public final void delayTask(@NotNull TransactionRunnable task) {
        this.myDelayedTasks.add(task);
    }

    @NotNull
    protected abstract String getActionName();

    protected abstract void perform(@NotNull Project var1, @NotNull List<VirtualFile> var2, @NotNull VirtualFile var3, Set<VirtualFile> var4, List<VcsException> var5) throws VcsException;

    public void update(AnActionEvent e) {
        super.update(e);
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setVisible(true);
        }
    }

    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        VirtualFile[] roots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        return roots != null && roots.length != 0;
    }
}

