/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogStatusInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GitCommit
extends VcsChangesLazilyParsedDetails {
    public GitCommit(Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<GitLogStatusInfo> reportedChanges) {
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime, (ThrowableComputable)new MyChangesComputable(new Data(project, root, reportedChanges, hash, commitTime, parents)));
    }

    private static class Data {
        private final Project project;
        private final VirtualFile root;
        private final List<GitLogStatusInfo> changesOutput;
        private final Hash hash;
        private final long time;
        private final List<Hash> parents;

        public Data(Project project, VirtualFile root, List<GitLogStatusInfo> changesOutput, Hash hash, long time, List<Hash> parents) {
            this.project = project;
            this.root = root;
            this.changesOutput = changesOutput;
            this.hash = hash;
            this.time = time;
            this.parents = parents;
        }
    }

    private static class MyChangesComputable
    implements ThrowableComputable<Collection<Change>, VcsException> {
        private Data myData;
        private Collection<Change> myChanges;

        public MyChangesComputable(Data data) {
            this.myData = data;
        }

        public Collection<Change> compute() throws VcsException {
            if (this.myChanges == null) {
                this.myChanges = GitChangesParser.parse(this.myData.project, this.myData.root, this.myData.changesOutput, this.myData.hash.asString(), new Date(this.myData.time), ContainerUtil.map((Collection)this.myData.parents, (Function)new Function<Hash, String>(){

                    public String fun(Hash hash) {
                        return hash.asString();
                    }
                }));
                this.myData = null;
            }
            return this.myChanges;
        }
    }
}

