/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelSpec;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodRuleAction;
import org.gradle.model.internal.inspect.RuleApplicationScope;
import org.gradle.model.internal.registry.ModelReferenceNode;
import org.gradle.model.internal.registry.ModelRegistry;

public class RuleExtractorUtils {
    public static void configureRuleAction(MethodModelRuleApplicationContext context, RuleApplicationScope ruleApplicationScope, ModelActionRole role, MethodRuleAction ruleAction) {
        ModelAction action = context.contextualize(ruleAction);
        ModelRegistry registry = context.getRegistry();
        switch (ruleApplicationScope) {
            case SELF: {
                registry.configure(role, action);
                break;
            }
            case DESCENDANTS: {
                registry.configureMatching(new NonReferenceDescendantsSpec(context.getScope()), role, action);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static class NonReferenceDescendantsSpec
    extends ModelSpec {
        private final ModelPath scope;

        private NonReferenceDescendantsSpec(ModelPath scope) {
            this.scope = scope;
        }

        @Nullable
        public ModelPath getAncestor() {
            return this.scope;
        }

        public boolean matches(MutableModelNode node) {
            return !(node instanceof ModelReferenceNode);
        }
    }
}

