/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.util.Ref;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.intellilang.instrumentation.ErrorPostponingMethodVisitor;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationAdapter;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.jps.intellilang.model.InstrumentationException;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;

class PatternInstrumenter
extends ClassVisitor
implements Opcodes {
    @NonNls
    static final String PATTERN_CACHE_NAME = "$_PATTERN_CACHE_$";
    @NonNls
    static final String ASSERTIONS_DISABLED_NAME = "$assertionsDisabled";
    @NonNls
    static final String JAVA_LANG_STRING = "Ljava/lang/String;";
    @NonNls
    static final String JAVA_UTIL_REGEX_PATTERN = "[Ljava/util/regex/Pattern;";
    private boolean myHasAssertions;
    private boolean myHasStaticInitializer;
    private final LinkedHashSet<String> myPatterns = new LinkedHashSet();
    private final String myPatternAnnotationClassName;
    final InstrumentationType myInstrumentationType;
    private final InstrumentationClassFinder myClassFinder;
    private final Map<String, String> myAnnotationNameToPatternMap = new HashMap<String, String>();
    private final Set<String> myProcessedAnnotations = new HashSet<String>();
    String myClassName;
    private boolean myInstrumented;
    private RuntimeException myPostponedError;
    boolean myIsNonStaticInnerClass;

    public PatternInstrumenter(@NotNull String patternAnnotationClassName, ClassVisitor classvisitor, InstrumentationType instrumentation, InstrumentationClassFinder classFinder) {
        super(327680, classvisitor);
        this.myPatternAnnotationClassName = patternAnnotationClassName;
        this.myInstrumentationType = instrumentation;
        this.myClassFinder = classFinder;
        this.myAnnotationNameToPatternMap.put(patternAnnotationClassName, null);
        this.myProcessedAnnotations.add(patternAnnotationClassName);
    }

    public boolean instrumented() {
        return this.myInstrumented;
    }

    void markInstrumented() {
        this.myInstrumented = true;
        this.processPostponedErrors();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (this.myClassName.equals(name)) {
            this.myIsNonStaticInnerClass = (access & 8) == 0;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals(ASSERTIONS_DISABLED_NAME)) {
            this.myHasAssertions = true;
        } else if (name.equals(PATTERN_CACHE_NAME)) {
            throw new InstrumentationException("Error: Processing an already instrumented class: " + this.myClassName + ". Please recompile the affected class(es) or rebuild the project.");
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (this.myInstrumented) {
            this.addField(PATTERN_CACHE_NAME, 4122, JAVA_UTIL_REGEX_PATTERN);
            if (this.myInstrumentationType == InstrumentationType.ASSERT && !this.myHasAssertions) {
                this.addField(ASSERTIONS_DISABLED_NAME, 4120, "Z");
            }
            if (!this.myHasStaticInitializer) {
                this.createStaticInitializer();
            }
        }
        super.visitEnd();
    }

    private void addField(String name, int modifiers, String type) {
        FieldVisitor fv = this.cv.visitField(modifiers, name, type, null, null);
        fv.visitEnd();
    }

    private void createStaticInitializer() {
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.patchStaticInitializer(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void patchStaticInitializer(MethodVisitor mv) {
        if (!this.myHasAssertions && this.myInstrumentationType == InstrumentationType.ASSERT) {
            this.initAssertions(mv);
        }
        this.initPatterns(mv);
    }

    private void initPatterns(MethodVisitor mv) {
        mv.visitIntInsn(16, this.myPatterns.size());
        mv.visitTypeInsn(189, "java/util/regex/Pattern");
        mv.visitFieldInsn(179, this.myClassName, PATTERN_CACHE_NAME, JAVA_UTIL_REGEX_PATTERN);
        int i = 0;
        for (String pattern : this.myPatterns) {
            try {
                Pattern.compile(pattern);
            }
            catch (Exception e) {
                throw new InstrumentationException("Illegal Pattern: " + pattern, e);
            }
            mv.visitFieldInsn(178, this.myClassName, PATTERN_CACHE_NAME, JAVA_UTIL_REGEX_PATTERN);
            mv.visitIntInsn(16, i++);
            mv.visitLdcInsn((Object)pattern);
            mv.visitMethodInsn(184, "java/util/regex/Pattern", "compile", "(Ljava/lang/String;)Ljava/util/regex/Pattern;", false);
            mv.visitInsn(83);
        }
    }

    private void initAssertions(MethodVisitor mv) {
        mv.visitLdcInsn((Object)Type.getType((String)("L" + this.myClassName + ";")));
        mv.visitMethodInsn(182, "java/lang/Class", "desiredAssertionStatus", "()Z", false);
        Label l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitFieldInsn(179, this.myClassName, ASSERTIONS_DISABLED_NAME, "Z");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodvisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 8) != 0 && name.equals("<clinit>")) {
            this.myHasStaticInitializer = true;
            return new ErrorPostponingMethodVisitor(this, name, methodvisitor){

                public void visitCode() {
                    super.visitCode();
                    PatternInstrumenter.this.patchStaticInitializer(this.mv);
                }
            };
        }
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        Type returnType = Type.getReturnType((String)desc);
        if (PatternInstrumenter.isStringType(returnType)) {
            return new InstrumentationAdapter(this, methodvisitor, argTypes, returnType, access, name);
        }
        for (Type type : argTypes) {
            if (!PatternInstrumenter.isStringType(type)) continue;
            return new InstrumentationAdapter(this, methodvisitor, argTypes, returnType, access, name);
        }
        return new ErrorPostponingMethodVisitor(this, name, methodvisitor);
    }

    private static boolean isStringType(Type type) {
        return type.getSort() == 10 && type.getDescriptor().equals(JAVA_LANG_STRING);
    }

    public int addPattern(String s) {
        if (this.myPatterns.add(s)) {
            return this.myPatterns.size() - 1;
        }
        return Arrays.asList(this.myPatterns.toArray()).indexOf(s);
    }

    public boolean acceptAnnotation(String annotationClassName) {
        if (annotationClassName == null) {
            return false;
        }
        this.processAnnotation(annotationClassName);
        return this.myAnnotationNameToPatternMap.containsKey(annotationClassName);
    }

    @Nullable
    public String getAnnotationPattern(String annotationClassName) {
        this.processAnnotation(annotationClassName);
        return this.myAnnotationNameToPatternMap.get(annotationClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAnnotation(String annotationClassName) {
        block7: {
            if (!this.myProcessedAnnotations.add(annotationClassName)) {
                return;
            }
            try {
                InputStream is = this.myClassFinder.getClassBytesAsStream(annotationClassName);
                if (is == null) break block7;
                try {
                    final Ref patternString = new Ref(null);
                    ClassVisitor visitor = new ClassVisitor(327680){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            if (patternString.get() != null || !PatternInstrumenter.this.myPatternAnnotationClassName.equals(Type.getType((String)desc).getClassName())) {
                                return null;
                            }
                            return new AnnotationVisitor(327680){

                                public void visit(@NonNls String name, Object value) {
                                    if ("value".equals(name) && value instanceof String) {
                                        patternString.set((Object)((String)value));
                                    }
                                }
                            };
                        }
                    };
                    new ClassReader(is).accept(visitor, 7);
                    String pattern = (String)patternString.get();
                    if (pattern != null) {
                        this.myAnnotationNameToPatternMap.put(annotationClassName, pattern);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void registerError(String methodName, String operationName, Throwable e) {
        if (this.myPostponedError == null) {
            Throwable err = e.getCause();
            if (err == null) {
                err = e;
            }
            StringBuilder message = new StringBuilder();
            message.append("Operation '").append(operationName).append("' failed for ").append(this.myClassName).append(".").append(methodName).append("(): ");
            String errMessage = err.getMessage();
            if (errMessage != null) {
                message.append(errMessage);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(out));
            message.append('\n').append(out.toString());
            this.myPostponedError = new RuntimeException(message.toString(), err);
        }
        if (this.myInstrumented) {
            this.processPostponedErrors();
        }
    }

    private void processPostponedErrors() {
        RuntimeException error = this.myPostponedError;
        if (error != null) {
            throw error;
        }
    }
}

