/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingBuildInfo;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.reflection.SdkUtil;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.GenerationalClassUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ProcessExpressions
extends ProcessDataBinding.ProcessingStep {
    @Override
    public boolean onHandleStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) throws JAXBException {
        SdkUtil.initialize(buildInfo.minSdk(), new File(buildInfo.sdkRoot()));
        ResourceBundle resourceBundle = new ResourceBundle(buildInfo.modulePackage());
        List<IntermediateV2> intermediateList = this.loadDependencyIntermediates();
        for (IntermediateV2 intermediate : intermediateList) {
            try {
                intermediate.appendTo(resourceBundle);
            }
            catch (Throwable throwable) {
                L.e((Throwable)throwable, (String)"unable to prepare resource bundle", (Object[])new Object[0]);
            }
        }
        IntermediateV2 mine = this.createIntermediateFromLayouts(buildInfo.layoutInfoDir(), intermediateList);
        if (mine != null) {
            mine.updateOverridden(resourceBundle);
            intermediateList.add(mine);
            this.saveIntermediate(processingEnvironment, buildInfo, mine);
            mine.appendTo(resourceBundle);
        }
        try {
            this.writeResourceBundle(resourceBundle, buildInfo.isLibrary(), buildInfo.minSdk(), buildInfo.exportClassListTo());
        }
        catch (Throwable t) {
            L.e((Throwable)t, (String)"cannot generate view binders", (Object[])new Object[0]);
        }
        return true;
    }

    private List<IntermediateV2> loadDependencyIntermediates() {
        List<Intermediate> original = GenerationalClassUtil.loadObjects(GenerationalClassUtil.ExtensionFilter.LAYOUT);
        ArrayList<IntermediateV2> upgraded = new ArrayList<IntermediateV2>(original.size());
        for (Intermediate intermediate : original) {
            Intermediate updatedIntermediate = intermediate.upgrade();
            Preconditions.check((boolean)(updatedIntermediate instanceof IntermediateV2), (String)"Incompatible data binding dependency. Please update your dependencies or recompile them with application module's data binding version.", (Object[])new Object[0]);
            upgraded.add((IntermediateV2)updatedIntermediate);
        }
        return upgraded;
    }

    private void saveIntermediate(ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo, IntermediateV2 intermediate) {
        GenerationalClassUtil.writeIntermediateFile(processingEnvironment, buildInfo.modulePackage(), buildInfo.modulePackage() + GenerationalClassUtil.ExtensionFilter.LAYOUT.getExtension(), intermediate);
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
    }

    private IntermediateV2 createIntermediateFromLayouts(String layoutInfoFolderPath, List<IntermediateV2> intermediateList) {
        final HashSet excludeList = new HashSet();
        for (IntermediateV2 lib : intermediateList) {
            excludeList.addAll(lib.mLayoutInfoMap.keySet());
        }
        File layoutInfoFolder = new File(layoutInfoFolderPath);
        if (!layoutInfoFolder.isDirectory()) {
            L.d((String)"layout info folder does not exist, skipping for %s", (Object[])new Object[]{layoutInfoFolderPath});
            return null;
        }
        IntermediateV2 result = new IntermediateV2();
        for (File layoutFile : layoutInfoFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") && !excludeList.contains(name);
            }
        })) {
            try {
                result.addEntry(layoutFile.getName(), FileUtils.readFileToString((File)layoutFile));
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"cannot load layout file information. Try a clean build", (Object[])new Object[0]);
            }
        }
        return result;
    }

    private void writeResourceBundle(ResourceBundle resourceBundle, boolean forLibraryModule, int minSdk, String exportClassNamesTo) throws JAXBException {
        CompilerChef compilerChef = CompilerChef.createChef(resourceBundle, this.getWriter());
        compilerChef.sealModels();
        compilerChef.writeComponent();
        if (compilerChef.hasAnythingToGenerate()) {
            compilerChef.writeViewBinderInterfaces(forLibraryModule);
            if (!forLibraryModule) {
                compilerChef.writeViewBinders(minSdk);
            }
        }
        if (forLibraryModule && exportClassNamesTo == null) {
            L.e((String)"When compiling a library module, build info must include exportClassListTo path", (Object[])new Object[0]);
        }
        if (forLibraryModule) {
            Set<String> classNames = compilerChef.getWrittenClassNames();
            String out = Joiner.on((String)StringUtils.LINE_SEPARATOR).join(classNames);
            L.d((String)"Writing list of classes to %s . \nList:%s", (Object[])new Object[]{exportClassNamesTo, out});
            try {
                FileUtils.write((File)new File(exportClassNamesTo), (CharSequence)out);
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"Cannot create list of written classes", (Object[])new Object[0]);
            }
        }
        this.mCallback.onChefReady(compilerChef, forLibraryModule, minSdk);
    }

    public static class IntermediateV2
    extends IntermediateV1 {
        private static final long serialVersionUID = 2L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle) throws JAXBException {
            for (Map.Entry entry : this.mLayoutInfoMap.entrySet()) {
                InputStream is = IOUtils.toInputStream((String)((String)entry.getValue()));
                try {
                    ResourceBundle.LayoutFileBundle bundle = ResourceBundle.LayoutFileBundle.fromXML((InputStream)is);
                    resourceBundle.addLayoutBundle(bundle);
                    L.d((String)"loaded layout info file %s", (Object[])new Object[]{bundle});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }

        public void updateOverridden(ResourceBundle bundle) throws JAXBException {
            HashMap bundles = bundle.getLayoutBundles();
            for (Map.Entry info : this.mLayoutInfoMap.entrySet()) {
                String key = LayoutXmlProcessor.exportLayoutNameFromInfoFileName((String)((String)info.getKey()));
                List existingList = (List)bundles.get(key);
                if (existingList == null || existingList.isEmpty()) continue;
                ResourceBundle.LayoutFileBundle myBundle = ResourceBundle.LayoutFileBundle.fromXML((InputStream)IOUtils.toInputStream((String)((String)info.getValue())));
                ResourceBundle.LayoutFileBundle inheritFrom = (ResourceBundle.LayoutFileBundle)existingList.get(0);
                myBundle.inheritConfigurationFrom(inheritFrom);
                L.d((String)"inheriting data for %s (%s) from %s", (Object[])new Object[]{info.getKey(), key, inheritFrom});
                this.mLayoutInfoMap.put(info.getKey(), myBundle.toXML());
            }
        }
    }

    public static class IntermediateV1
    implements Intermediate {
        transient Unmarshaller mUnmarshaller;
        Map<String, String> mLayoutInfoMap = new HashMap<String, String>();

        @Override
        public Intermediate upgrade() {
            IntermediateV2 updated = new IntermediateV2();
            updated.mLayoutInfoMap = this.mLayoutInfoMap;
            updated.mUnmarshaller = this.mUnmarshaller;
            return updated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendTo(ResourceBundle resourceBundle) throws JAXBException {
            if (this.mUnmarshaller == null) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ResourceBundle.LayoutFileBundle.class});
                this.mUnmarshaller = context.createUnmarshaller();
            }
            for (String content : this.mLayoutInfoMap.values()) {
                InputStream is = IOUtils.toInputStream((String)content);
                try {
                    ResourceBundle.LayoutFileBundle bundle = (ResourceBundle.LayoutFileBundle)this.mUnmarshaller.unmarshal(is);
                    resourceBundle.addLayoutBundle(bundle);
                    L.d((String)"loaded layout info file %s", (Object[])new Object[]{bundle});
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }

        public void addEntry(String name, String contents) {
            this.mLayoutInfoMap.put(name, contents);
        }

        public void removeOverridden(List<Intermediate> existing) {
        }
    }

    public static interface Intermediate
    extends Serializable {
        public Intermediate upgrade();

        public void appendTo(ResourceBundle var1) throws Throwable;
    }
}

