/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsExecution;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsResultEx;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvsExecution.ModalityContextImpl;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.cvsIntegration.CvsResult;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ErrorTreeView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CvsOperationExecutor {
    private final CvsResultEx myResult = new CvsResultEx();
    private final boolean myShowProgress;
    private final Project myProject;
    private final ModalityContext myExecutor;
    private boolean myShowErrors = true;
    private boolean myIsQuietOperation = false;
    @Nullable
    private final CvsConfiguration myConfiguration;

    public CvsOperationExecutor(boolean showProgress, Project project, ModalityState modalityState) {
        this.myProject = project;
        this.myShowProgress = showProgress;
        this.myExecutor = new ModalityContextImpl(modalityState);
        this.myConfiguration = project != null ? CvsConfiguration.getInstance(project) : null;
    }

    public CvsOperationExecutor(boolean showProgress, Project project, ModalityContext modalityContext) {
        this.myProject = project;
        this.myShowProgress = showProgress;
        this.myExecutor = modalityContext;
        this.myConfiguration = project != null ? CvsConfiguration.getInstance(project) : null;
    }

    public CvsOperationExecutor(Project project) {
        this(true, project, ModalityState.defaultModalityState());
    }

    public CvsOperationExecutor(Project project, ModalityState modalityState) {
        this(true, project, modalityState);
    }

    public void performActionSync(final CvsHandler handler, final CvsOperationExecutorCallback callback) {
        final CvsTabbedWindow tabbedWindow = this.myIsQuietOperation ? null : this.openTabbedWindow(handler);
        final Runnable finish = new Runnable(){

            @Override
            public void run() {
                block15: {
                    block14: {
                        try {
                            CvsOperationExecutor.this.myResult.addAllErrors(handler.getErrorsExceptAborted());
                            handler.finish();
                            if (CvsOperationExecutor.this.myProject != null && CvsOperationExecutor.this.myProject.isDisposed()) break block14;
                            CvsOperationExecutor.this.showErrors(handler, tabbedWindow);
                        }
                        catch (Throwable throwable) {
                            block16: {
                                try {
                                    if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(handler)) {
                                        callback.executionFinished(false);
                                        break block16;
                                    }
                                    if (handler.getErrors().isEmpty()) {
                                        callback.executionFinishedSuccessfully();
                                    }
                                    callback.executionFinished(true);
                                }
                                catch (Throwable throwable2) {
                                    if (CvsOperationExecutor.this.myProject != null && handler != CvsHandler.NULL) {
                                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                StatusBar.Info.set((String)CvsOperationExecutor.getStatusMessage(handler), (Project)CvsOperationExecutor.this.myProject);
                                            }
                                        });
                                    }
                                    throw throwable2;
                                }
                            }
                            if (CvsOperationExecutor.this.myProject != null && handler != CvsHandler.NULL) {
                                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(handler)) {
                            callback.executionFinished(false);
                            break block15;
                        }
                        if (handler.getErrors().isEmpty()) {
                            callback.executionFinishedSuccessfully();
                        }
                        callback.executionFinished(true);
                    }
                    catch (Throwable throwable) {
                        if (CvsOperationExecutor.this.myProject != null && handler != CvsHandler.NULL) {
                            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw throwable;
                    }
                }
                if (CvsOperationExecutor.this.myProject != null && handler != CvsHandler.NULL) {
                    ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
        };
        final Runnable cvsAction = new Runnable(){

            @Override
            public void run() {
                try {
                    if (handler == CvsHandler.NULL) {
                        return;
                    }
                    CvsOperationExecutor.setText(CvsBundle.message((String)"progress.text.preparing.for.login", (Object[])new Object[0]));
                    handler.beforeLogin();
                    if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(handler)) {
                        return;
                    }
                    CvsOperationExecutor.setText(CvsBundle.message((String)"progress.text.preparing.for.action", (Object[])new Object[]{handler.getTitle()}));
                    handler.run(CvsOperationExecutor.this.myProject, CvsOperationExecutor.this.myExecutor);
                    if (CvsOperationExecutor.this.myResult.finishedUnsuccessfully(handler)) {
                        return;
                    }
                }
                catch (ProcessCanceledException ex) {
                    CvsOperationExecutor.this.myResult.setIsCanceled();
                }
                finally {
                    callback.executeInProgressAfterAction(CvsOperationExecutor.this.myExecutor);
                }
            }
        };
        if (this.doNotShowProgress()) {
            cvsAction.run();
            if (this.myIsQuietOperation) {
                finish.run();
            } else {
                this.myExecutor.runInDispatchThread(finish, this.myProject);
            }
        } else {
            PerformInBackgroundOption backgroundOption = handler.getBackgroundOption(this.myProject);
            if (backgroundOption != null) {
                Task.Backgroundable task = new Task.Backgroundable(this.myProject, handler.getTitle(), handler.canBeCanceled(), backgroundOption){

                    public void run(@NotNull ProgressIndicator indicator) {
                        cvsAction.run();
                    }

                    public void onSuccess() {
                        finish.run();
                    }
                };
                ProgressManager.getInstance().run((Task)task);
            } else if (ProgressManager.getInstance().runProcessWithProgressSynchronously(cvsAction, handler.getTitle(), handler.canBeCanceled(), this.myProject)) {
                finish.run();
            }
        }
    }

    private static void setText(String text) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(text);
        }
    }

    private boolean doNotShowProgress() {
        return CvsOperationExecutor.isInProgress() || CvsOperationExecutor.isInTestMode() || !this.myShowProgress || !ApplicationManager.getApplication().isDispatchThread();
    }

    private static boolean isInTestMode() {
        return ApplicationManager.getApplication().isUnitTestMode();
    }

    private static boolean isInProgress() {
        return ProgressManager.getInstance().getProgressIndicator() != null;
    }

    protected void showErrors(CvsHandler handler, CvsTabbedWindow tabbedWindow) {
        List<VcsException> errors = handler.getErrorsExceptAborted();
        if (!this.myShowErrors || this.myIsQuietOperation) {
            return;
        }
        if (tabbedWindow == null) {
            if (errors.isEmpty()) {
                return;
            }
            ArrayList<String> messages = new ArrayList<String>();
            for (VcsException error : errors) {
                if (StringUtil.isEmptyOrSpaces((String)error.getMessage())) continue;
                messages.add(error.getMessage());
            }
            String errorMessage = StringUtil.join(messages, (String)"\n");
            Messages.showErrorDialog((String)errorMessage, (String)"CVS Error");
            return;
        }
        if (!errors.isEmpty()) {
            ErrorTreeView errorTreeView = tabbedWindow.getErrorsTreeView();
            for (VcsException exception : errors) {
                String groupName = DateFormatUtil.formatDateTime((long)System.currentTimeMillis()) + ' ' + handler.getTitle();
                if (exception.isWarning()) {
                    errorTreeView.addMessage(5, exception.getMessages(), groupName, NonNavigatable.INSTANCE, null, null, (Object)exception);
                    continue;
                }
                errorTreeView.addMessage(4, exception.getMessages(), groupName, NonNavigatable.INSTANCE, null, null, (Object)exception);
            }
        }
    }

    private static String getStatusMessage(CvsHandler handler) {
        String actionName = handler.getTitle();
        if (handler.getErrors().isEmpty()) {
            return CvsBundle.message((String)"status.text.action.completed", (Object[])new Object[]{actionName});
        }
        return CvsBundle.message((String)"status.text.action.completed.with.errors", (Object[])new Object[]{actionName});
    }

    @Nullable
    public CvsTabbedWindow openTabbedWindow(final CvsHandler output) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (this.myProject != null && this.myProject.isDefault()) {
            return null;
        }
        if (this.myProject != null) {
            if (this.myConfiguration != null && this.myConfiguration.SHOW_OUTPUT && !this.myIsQuietOperation) {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CvsOperationExecutor.this.connectToOutput(output);
                    }
                }, ModalityState.defaultModalityState());
            }
            if (!this.myProject.isDisposed()) {
                return CvsTabbedWindow.getInstance(this.myProject);
            }
        }
        return null;
    }

    private void connectToOutput(CvsHandler output) {
        output.connectToOutputView(CvsTabbedWindow.getInstance(this.myProject).getOutput(), this.myProject);
    }

    public VcsException getFirstError() {
        return this.myResult.composeError();
    }

    public boolean hasNoErrors() {
        return !this.myResult.hasErrors();
    }

    public CvsResult getResult() {
        return this.myResult;
    }

    public void setShowErrors(boolean showErrors) {
        this.myShowErrors = showErrors;
    }

    public void setIsQuietOperation(boolean isQuietOperation) {
        this.myIsQuietOperation = isQuietOperation;
    }
}

