/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.merge;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.merge.CvsConflictsParser;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsMergeProvider
implements MergeProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) throws VcsException {
        MergeData mergeData;
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(file);
        File cvsFile = CvsVfsUtil.getFileFor(file);
        if (entry != null && entry.isResultOfMerge() && entry.isBinary()) {
            String originalRevision = CvsUtil.getOriginalRevisionForFile(file);
            MergeData mergeData2 = new MergeData();
            mergeData2.CURRENT = CvsUtil.getStoredContentForFile(file, originalRevision);
            mergeData2.LAST = FileUtil.loadFileBytes((File)cvsFile);
            return mergeData2;
        }
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(cvsFile));
        try {
            CvsConflictsParser parser = CvsConflictsParser.createOn(input);
            MergeData mergeData3 = new MergeData();
            mergeData3.ORIGINAL = parser.getCenterVersion().getBytes();
            mergeData3.CURRENT = parser.getLeftVersion().getBytes();
            mergeData3.LAST = parser.getRightVersion().getBytes();
            mergeData = mergeData3;
        }
        catch (Throwable throwable) {
            try {
                input.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
        input.close();
        return mergeData;
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        CvsUtil.resolveConflict(file);
        CvsEntriesManager.getInstance().clearCachedEntriesFor(file.getParent());
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        return false;
    }
}

