/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.checkinProject.AdditionalOptionsPanel;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CvsCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    CvsCheckinHandlerFactory() {
        super(CvsVcs2.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(final CheckinProjectPanel panel) {
        return new CheckinHandler(){

            @Nullable
            public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
                Project project = panel.getProject();
                CvsVcs2 cvs = CvsVcs2.getInstance(project);
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                Collection roots = panel.getRoots();
                HashSet files = new HashSet();
                for (VirtualFile root : roots) {
                    VcsRoot vcsRoot = vcsManager.getVcsRootObjectFor(root);
                    if (vcsRoot == null || vcsRoot.getVcs() != cvs) continue;
                    files.add(VcsContextFactory.SERVICE.getInstance().createFilePathOn(root));
                }
                return new AdditionalOptionsPanel(CvsConfiguration.getInstance(project), (Collection<FilePath>)files, project);
            }
        };
    }
}

