/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLScalarText;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;

public class YAMLScalarTextImpl
extends YAMLBlockScalarImpl
implements YAMLScalarText {
    public YAMLScalarTextImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        return YAMLTokenTypes.SCALAR_TEXT;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence leftString, @NotNull CharSequence rightString) {
        if (StringUtil.isEmptyOrSpaces((CharSequence)leftString)) {
            return "\n";
        }
        if (StringUtil.startsWithChar((CharSequence)leftString, (char)' ') || StringUtil.startsWithChar((CharSequence)leftString, (char)'\t') || StringUtil.startsWithChar((CharSequence)rightString, (char)' ') || StringUtil.startsWithChar((CharSequence)rightString, (char)'\t')) {
            return "\n";
        }
        if (StringUtil.isEmptyOrSpaces((CharSequence)rightString)) {
            return "";
        }
        return " ";
    }

    @Override
    @NotNull
    public String getTextValue() {
        return super.getTextValue() + "\n";
    }

    @Override
    public String toString() {
        return "YAML scalar text";
    }
}

