/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public abstract class YAMLBlockScalarImpl
extends YAMLScalarImpl {
    public YAMLBlockScalarImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    protected abstract IElementType getContentType();

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        int myStart = this.getTextOffset();
        ASTNode node = this.getNode();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int indent = this.locateIndent();
        ASTNode firstEol = node.findChildByType((IElementType)YAMLTokenTypes.EOL);
        if (firstEol == null) {
            return Collections.emptyList();
        }
        int thisLineStart = firstEol.getStartOffset() + 1;
        for (ASTNode child = firstEol.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == this.getContentType()) {
                assert (thisLineStart != -1);
                result.add(TextRange.create((int)thisLineStart, (int)child.getTextRange().getEndOffset()).shiftRight(-myStart));
                thisLineStart = -1;
                if (node.findChildByType(this.getContentType(), child.getTreeNext()) == null) {
                    break;
                }
            } else if (child.getElementType() == YAMLTokenTypes.INDENT) {
                thisLineStart = child.getStartOffset() + Math.min(indent, child.getTextLength());
            }
            if (child.getElementType() != YAMLTokenTypes.EOL) continue;
            if (thisLineStart != -1) {
                result.add(TextRange.create((int)thisLineStart, (int)child.getStartOffset()).shiftRight(-myStart));
            }
            thisLineStart = child.getStartOffset() + 1;
        }
        return result;
    }

    private int locateIndent() {
        int number = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != this.getContentType() || ++number != 2) continue;
            return YAMLUtil.getIndentInThisLine(child.getPsi());
        }
        return 0;
    }
}

