/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class LocaleDetector
extends Detector
implements Detector.ClassScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.CLASS_FILE_SCOPE);
    public static final Issue STRING_LOCALE = Issue.create((String)"DefaultLocale", (String)"Implied default locale in case conversion", (String)"Calling `String#toLowerCase()` or `#toUpperCase()` *without specifying an explicit locale* is a common source of bugs. The reason for that is that those methods will use the current locale on the user's device, and even though the code appears to work correctly when you are developing the app, it will fail in some locales. For example, in the Turkish locale, the uppercase replacement for `i` is *not* `I`.\n\nIf you want the methods to just perform ASCII replacement, for example to convert an enum name, call `String#toUpperCase(Locale.US)` instead. If you really want to use the current locale, call `String#toUpperCase(Locale.getDefault())` instead.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html#default_locale");
    static final String DATE_FORMAT_OWNER = "java/text/SimpleDateFormat";
    private static final String STRING_OWNER = "java/lang/String";

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<String> getApplicableCallNames() {
        return Arrays.asList("toLowerCase", "toUpperCase", "format");
    }

    public void checkCall(ClassContext context, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        String owner = call.owner;
        if (!owner.equals(STRING_OWNER)) {
            return;
        }
        String desc = call.desc;
        String name = call.name;
        if (name.equals("format")) {
            if (!desc.equals("(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;")) {
                return;
            }
            Analyzer analyzer = new Analyzer((Interpreter)new SourceInterpreter(){

                public SourceValue newOperation(AbstractInsnNode insn) {
                    Object cst;
                    if (insn.getOpcode() == 18 && (cst = ((LdcInsnNode)insn).cst) instanceof String) {
                        return new StringValue(1, (String)cst);
                    }
                    return super.newOperation(insn);
                }
            });
            try {
                String format;
                Frame[] frames = analyzer.analyze(classNode.name, method);
                InsnList instructions = method.instructions;
                Frame frame = frames[instructions.indexOf((AbstractInsnNode)call)];
                if (frame.getStackSize() == 0) {
                    return;
                }
                SourceValue stackValue = (SourceValue)frame.getStack(0);
                if (stackValue instanceof StringValue && (format = ((StringValue)stackValue).getString()) != null && StringFormatDetector.isLocaleSpecific(format)) {
                    Location location = context.getLocation((AbstractInsnNode)call);
                    String message = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
                    context.report(STRING_LOCALE, method, (AbstractInsnNode)call, location, message);
                }
            }
            catch (AnalyzerException e) {
                context.log((Throwable)e, null, new Object[0]);
            }
        } else if (desc.equals("()Ljava/lang/String;")) {
            Location location = context.getLocation((AbstractInsnNode)call);
            String message = String.format("Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead", name);
            context.report(STRING_LOCALE, method, (AbstractInsnNode)call, location, message);
        }
    }

    private static class StringValue
    extends SourceValue {
        private final String mString;

        StringValue(int size, String string) {
            super(size);
            this.mString = string;
        }

        String getString() {
            return this.mString;
        }

        public int getSize() {
            return 1;
        }
    }
}

