/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.ExternalAnnotationRepository;
import com.android.tools.lint.psi.EcjPsiBinaryAnnotation;
import com.android.tools.lint.psi.EcjPsiBinaryElement;
import com.android.tools.lint.psi.EcjPsiManager;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;

class EcjPsiPackage
extends EcjPsiBinaryElement
implements PsiPackage,
PsiModifierList {
    private final PackageBinding mPackageBinding;

    public EcjPsiPackage(EcjPsiManager manager, PackageBinding binding) {
        super(manager, (Binding)binding);
        this.mPackageBinding = binding;
    }

    public String getQualifiedName() {
        return EcjPsiManager.getTypeName(this.mPackageBinding.compoundName);
    }

    public String getName() {
        return new String(this.mPackageBinding.compoundName[this.mPackageBinding.compoundName.length - 1]);
    }

    public PsiPackage getParentPackage() {
        return null;
    }

    public PsiQualifiedNamedElement getContainer() {
        return null;
    }

    public PsiModifierList getAnnotationList() {
        return this.getModifierList();
    }

    public PsiModifierList getModifierList() {
        return this;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return false;
    }

    public boolean hasExplicitModifier(@PsiModifier.ModifierConstant String s) {
        return false;
    }

    public PsiAnnotation[] getAnnotations() {
        return this.getApplicableAnnotations();
    }

    public PsiAnnotation[] getApplicableAnnotations() {
        return this.findAnnotations(false);
    }

    private PsiAnnotation[] findAnnotations(boolean includeSuper) {
        Collection<PsiAnnotation> external;
        ArrayList all = Lists.newArrayListWithExpectedSize((int)4);
        ExternalAnnotationRepository manager = this.mManager.getAnnotationRepository();
        PackageBinding binding = this.mPackageBinding;
        AnnotationBinding[] annotations = binding.getAnnotations();
        int count = annotations.length;
        if (count > 0) {
            for (AnnotationBinding annotation : annotations) {
                if (annotation == null) continue;
                all.add(new EcjPsiBinaryAnnotation(this.mManager, (PsiAnnotationOwner)this, annotation));
            }
        }
        if (manager != null && (external = manager.getAnnotations(binding)) != null) {
            all.addAll(external);
        }
        return EcjPsiManager.ensureUnique(all);
    }

    public PsiAnnotation findAnnotation(String s) {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!s.equals(qualifiedName)) continue;
            return annotation;
        }
        return null;
    }

    public PackageBinding getPackageBinding() {
        return this.mPackageBinding;
    }
}

