/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiBinaryMethod;
import com.android.tools.lint.psi.EcjPsiClass;
import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiMember;
import com.android.tools.lint.psi.EcjPsiModifierList;
import com.android.tools.lint.psi.ExternalPsiReferenceExpressionMemberValue;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.javadoc.PsiDocComment;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

class EcjPsiMethod
extends EcjPsiMember
implements PsiMethod {
    private final AbstractMethodDeclaration mDeclaration;
    private final String mName;
    private PsiIdentifier mIdentifier;
    private EcjPsiModifierList mModifierList;
    private PsiCodeBlock mBody;
    private PsiParameterList mArguments;
    private PsiTypeParameterList mTypeParameters;
    private PsiReferenceList mThrownExceptions;
    private PsiTypeElement mReturnTypeElement;

    EcjPsiMethod(EcjPsiManager manager, EcjPsiClass containingClass, AbstractMethodDeclaration declaration) {
        super(manager, containingClass, null);
        this.setRange(declaration.declarationSourceStart, declaration.declarationSourceEnd + 1);
        this.mDeclaration = declaration;
        this.mNativeNode = this.mDeclaration;
        this.mName = new String(declaration.selector);
        manager.registerElement((Binding)declaration.binding, this);
    }

    void setNameIdentifier(PsiIdentifier identifier) {
        this.mIdentifier = identifier;
    }

    void setModifierList(EcjPsiModifierList modifierList) {
        this.mModifierList = modifierList;
    }

    void setBody(PsiCodeBlock body) {
        this.mBody = body;
    }

    void setArguments(PsiParameterList arguments) {
        this.mArguments = arguments;
    }

    void setTypeParameters(PsiTypeParameterList typeParameters) {
        this.mTypeParameters = typeParameters;
    }

    void setThrownExceptions(PsiReferenceList thrownExceptions) {
        this.mThrownExceptions = thrownExceptions;
    }

    void setReturnTypeElement(PsiTypeElement returnTypeElement) {
        this.mReturnTypeElement = returnTypeElement;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.mIdentifier;
    }

    public PsiModifierList getModifierList() {
        return this.mModifierList;
    }

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant String s) {
        return this.mModifierList != null && this.mModifierList.hasModifierProperty(s);
    }

    public PsiParameterList getParameterList() {
        return this.mArguments;
    }

    public PsiReferenceList getThrowsList() {
        return this.mThrownExceptions;
    }

    public PsiCodeBlock getBody() {
        return this.mBody;
    }

    public boolean isConstructor() {
        return this.mDeclaration.isConstructor();
    }

    public boolean isVarArgs() {
        PsiParameter[] parameters = this.getParameterList().getParameters();
        return parameters.length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    public PsiType getReturnType() {
        return this.mDeclaration instanceof MethodDeclaration ? this.mManager.findType(((MethodDeclaration)this.mDeclaration).returnType) : null;
    }

    public PsiTypeElement getReturnTypeElement() {
        return this.mReturnTypeElement;
    }

    public PsiMethod[] findSuperMethods() {
        return this.getSuperMethods(true);
    }

    private PsiMethod[] getSuperMethods(boolean checkAccess) {
        PsiMethod method;
        if (this.mDeclaration.binding == null) {
            return PsiMethod.EMPTY_ARRAY;
        }
        MethodBinding superBinding = EcjPsiManager.findSuperMethodBinding(this.mDeclaration.binding, false, checkAccess);
        if (superBinding != null && (method = this.mManager.findMethod((Binding)superBinding)) != null) {
            return new PsiMethod[]{method};
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return this.getSuperMethods(checkAccess);
    }

    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod findDeepestSuperMethod() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiMethod[] findDeepestSuperMethods() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return this.mDeclaration.binding != null && (this.mDeclaration.binding.modifiers & 0x100000) != 0;
    }

    public boolean hasTypeParameters() {
        return this.mTypeParameters != null;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.mTypeParameters;
    }

    public PsiTypeParameter[] getTypeParameters() {
        return this.mTypeParameters != null ? this.mTypeParameters.getTypeParameters() : PsiTypeParameter.EMPTY_ARRAY;
    }

    MethodBinding getBinding() {
        return this.mDeclaration.binding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        MethodBinding binding = this.mDeclaration.binding;
        if (o instanceof EcjPsiMethod) {
            MethodBinding otherBinding = ((EcjPsiMethod)o).getBinding();
            if (binding == null || otherBinding == null) {
                return this.mDeclaration.equals(((EcjPsiMethod)o).mDeclaration);
            }
            return binding.equals(otherBinding);
        }
        if (o instanceof EcjPsiBinaryMethod) {
            MethodBinding otherBinding = ((EcjPsiBinaryMethod)o).getBinding();
            return binding != null && otherBinding != null && binding.equals(otherBinding);
        }
        if (o instanceof ExternalPsiReferenceExpressionMemberValue) {
            String fqn;
            String signature = ((ExternalPsiReferenceExpressionMemberValue)o).getQualifiedName();
            PsiClass containingClass = this.getContainingClass();
            if (containingClass != null && (fqn = containingClass.getQualifiedName()) != null && signature.startsWith(fqn) && signature.endsWith(this.getName()) && signature.length() == fqn.length() + this.getName().length() + 1) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.mDeclaration.binding != null ? this.mDeclaration.binding.hashCode() : 0;
    }
}

