/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Copy;
import org.gradle.nativeplatform.NativeBinarySpec;

public class MergeNativeLibrariesConfigAction
implements Action<Copy> {
    private final NativeBinarySpec binary;
    private final File inputFolder;
    private final Collection<File> inputFiles;
    private final Collection<FileCollection> inputFileCollections;
    private final File buildDir;

    public MergeNativeLibrariesConfigAction(NativeBinarySpec binary, File inputFolder, Collection<File> inputFiles, Collection<FileCollection> inputFileCollections, File buildDir) {
        this.binary = binary;
        this.inputFolder = inputFolder;
        this.inputFiles = inputFiles;
        this.inputFileCollections = inputFileCollections;
        this.buildDir = buildDir;
    }

    public void execute(Copy task) {
        task.from(new Object[]{this.inputFolder});
        task.from(new Object[]{this.inputFiles});
        task.from(new Object[]{this.inputFileCollections});
        task.into((Object)new File(this.buildDir, NdkNamingScheme.getOutputDirectoryName(this.binary)));
        task.dependsOn(new Object[]{this.binary});
    }
}

