/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.managed.NdkAbiOptions;
import java.util.Collections;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.gcc.DefaultGccPlatformToolChain;
import org.gradle.platform.base.PlatformContainer;

public class ToolchainConfiguration {
    public static void configurePlatforms(PlatformContainer platforms, NdkHandler ndkHandler) {
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            NativePlatform platform = (NativePlatform)platforms.maybeCreate(abi.getName(), NativePlatform.class);
            platform.architecture("ppc");
            platform.operatingSystem("linux");
        }
    }

    public static void configureToolchain(NativeToolChainRegistry toolchainRegistry, String toolchainName, ModelMap<NdkAbiOptions> abiConfigs, NdkHandler ndkHandler) {
        Toolchain ndkToolchain = Toolchain.getByName((String)toolchainName);
        toolchainRegistry.create("ndk-" + toolchainName, toolchainName.equals("gcc") ? Gcc.class : Clang.class, toolchain -> {
            for (Abi abi : ndkHandler.getSupportedAbis()) {
                toolchain.target(abi.getName(), targetPlatform -> {
                    if (OperatingSystem.current().isWindows() && toolchainName.equals("clang")) {
                        ((DefaultGccPlatformToolChain)targetPlatform).setCanUseCommandFile(false);
                    }
                    if (Toolchain.GCC == ndkToolchain) {
                        String gccPrefix = abi.getGccExecutablePrefix();
                        targetPlatform.getcCompiler().setExecutable(gccPrefix + "-gcc");
                        targetPlatform.getCppCompiler().setExecutable(gccPrefix + "-g++");
                        targetPlatform.getLinker().setExecutable(gccPrefix + "-g++");
                        targetPlatform.getAssembler().setExecutable(gccPrefix + "-as");
                    }
                    targetPlatform.getStaticLibArchiver().setExecutable(ndkHandler.getAr(abi).getName());
                    targetPlatform.getLinker().withArguments(args -> args.removeAll(Collections.singleton("-Xlinker")));
                    NdkAbiOptions config = (NdkAbiOptions)abiConfigs.get(abi.getName());
                    String sysroot = config == null || config.getPlatformVersion() == null ? ndkHandler.getSysroot(abi) : ndkHandler.getSysroot(abi, config.getPlatformVersion());
                    targetPlatform.getcCompiler().withArguments(args -> args.add("--sysroot=" + sysroot));
                    targetPlatform.getCppCompiler().withArguments(args -> args.add("--sysroot=" + sysroot));
                    targetPlatform.getLinker().withArguments(args -> args.add("--sysroot=" + sysroot));
                    if (config != null) {
                        targetPlatform.getcCompiler().withArguments(args -> args.addAll(config.getCFlags()));
                        targetPlatform.getCppCompiler().withArguments(args -> args.addAll(config.getCppFlags()));
                        targetPlatform.getLinker().withArguments(args -> {
                            args.addAll(config.getLdFlags());
                            for (String lib : config.getLdLibs()) {
                                args.add("-l" + lib);
                            }
                        });
                    }
                });
                toolchain.path(new Object[]{ndkHandler.getCCompiler(abi).getParentFile(), ndkHandler.getAr(abi).getParentFile()});
            }
        });
    }
}

