/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dependency.AndroidNativeDependencySpec;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeDependencyResolver;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifact;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifactAdaptor;
import com.android.build.gradle.internal.ndk.NativeToolSpecification;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.build.gradle.managed.NdkConfig;
import com.android.build.gradle.model.NativeSourceSet;
import com.android.build.gradle.ndk.internal.DefaultNativeToolSpecification;
import com.android.build.gradle.ndk.internal.NativeToolSpecificationFactory;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import com.android.build.gradle.ndk.internal.StlConfiguration;
import com.android.build.gradle.tasks.MergeNativeLibrariesConfigAction;
import com.android.utils.StringHelper;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.Copy;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.c.CSourceSet;
import org.gradle.language.c.tasks.CCompile;
import org.gradle.language.cpp.CppSourceSet;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryBinarySpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.resolve.DefaultNativeDependencySet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class NdkConfiguration {
    public static void configureProperties(NativeLibrarySpec library, ModelMap<FunctionalSourceSet> sources, final File buildDir, NdkHandler ndkHandler, ServiceRegistry serviceRegistry) {
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            library.targetPlatform(abi.getName());
        }
        library.getBinaries().beforeEach(binary -> ((BinarySpecInternal)binary).setBuildable(false));
        library.getBinaries().withType(NativeLibraryBinarySpec.class, binary -> {
            Map<String, NativeSourceSet> jniSources = NdkConfiguration.findNativeSourceSets((NativeBinarySpec)binary, sources);
            for (Map.Entry<String, NativeSourceSet> entry : jniSources.entrySet()) {
                NdkConfiguration.addNativeSourceSets((BinarySpec)binary, entry.getKey(), entry.getValue());
            }
            binary.getcCompiler().define("ANDROID");
            binary.getCppCompiler().define("ANDROID");
            binary.getcCompiler().define("ANDROID_NDK");
            binary.getCppCompiler().define("ANDROID_NDK");
            binary.getTasks().withType(CCompile.class, (Action)new Action<CCompile>(){

                public void execute(CCompile task) {
                    String sourceSetName = task.getObjectFileDir().getName();
                    task.setObjectFileDir(NdkNamingScheme.getObjectFilesOutputDirectory(buildDir, sourceSetName));
                }
            });
            binary.getTasks().withType(CppCompile.class, (Action)new Action<CppCompile>(){

                public void execute(CppCompile task) {
                    String sourceSetName = task.getObjectFileDir().getName();
                    task.setObjectFileDir(NdkNamingScheme.getObjectFilesOutputDirectory(buildDir, sourceSetName));
                }
            });
            NdkConfiguration.applyNativeToolSpecification(new DefaultNativeToolSpecification(), (NativeBinarySpec)binary);
            binary.getLinker().args(new String[]{"-Wl,--build-id"});
            for (NativeSourceSet jniSource : jniSources.values()) {
                NdkConfiguration.handleDependencies((NativeBinarySpec)binary, NdkConfiguration.resolveDependency(serviceRegistry, (NativeBinarySpec)binary, jniSource));
            }
        });
    }

    public static void configureNativeBinaryOutputFile(NativeLibraryBinarySpec binary, File buildDir, String moduleName) {
        if (binary instanceof SharedLibraryBinarySpec) {
            ((SharedLibraryBinarySpec)binary).setSharedLibraryFile(new File(buildDir, NdkNamingScheme.getDebugLibraryDirectoryName((NativeBinarySpec)binary) + "/" + NdkNamingScheme.getSharedLibraryFileName(moduleName)));
            ((SharedLibraryBinarySpec)binary).setSharedLibraryLinkFile(new File(buildDir, NdkNamingScheme.getDebugLibraryDirectoryName((NativeBinarySpec)binary) + "/" + NdkNamingScheme.getSharedLibraryFileName(moduleName)));
        } else if (binary instanceof StaticLibraryBinarySpec) {
            ((StaticLibraryBinarySpec)binary).setStaticLibraryFile(new File(buildDir, NdkNamingScheme.getDebugLibraryDirectoryName((NativeBinarySpec)binary) + "/" + NdkNamingScheme.getStaticLibraryFileName(moduleName)));
        } else {
            throw new AssertionError((Object)"Should be unreachable");
        }
    }

    public static void configureBinary(NativeLibraryBinarySpec binary, NdkConfig ndkConfig, NdkHandler ndkHandler) {
        Abi abi = Abi.getByName((String)binary.getTargetPlatform().getName());
        String sysroot = ndkHandler.getSysroot(abi);
        if (ndkConfig.getRenderscriptNdkMode().booleanValue()) {
            binary.getcCompiler().args(new String[]{"-I" + sysroot + "/usr/include/rs"});
            binary.getcCompiler().args(new String[]{"-I" + sysroot + "/usr/include/rs/cpp"});
            binary.getCppCompiler().args(new String[]{"-I" + sysroot + "/usr/include/rs"});
            binary.getCppCompiler().args(new String[]{"-I" + sysroot + "/usr/include/rs/cpp"});
            binary.getLinker().args(new String[]{"-L" + sysroot + "/usr/lib/rs"});
        }
        StlNativeToolSpecification stlConfig = ndkHandler.getStlNativeToolSpecification(Stl.getById((String)ndkConfig.getStl()), ndkConfig.getStlVersion(), abi);
        NdkConfiguration.applyNativeToolSpecification((NativeToolSpecification)stlConfig, (NativeBinarySpec)binary);
        NdkConfiguration.applyNativeToolSpecification(NativeToolSpecificationFactory.create(ndkHandler, binary.getTargetPlatform(), (Boolean)Objects.firstNonNull((Object)ndkConfig.getDebuggable(), (Object)false)), (NativeBinarySpec)binary);
        for (String flag : ndkConfig.getCFlags()) {
            binary.getcCompiler().args(new String[]{flag.trim()});
        }
        for (String flag : ndkConfig.getCppFlags()) {
            binary.getCppCompiler().args(new String[]{flag.trim()});
        }
        for (String flag : ndkConfig.getLdFlags()) {
            binary.getLinker().args(new String[]{flag.trim()});
        }
        for (String ldLib : ndkConfig.getLdLibs()) {
            binary.getLinker().args(new String[]{"-l" + ldLib.trim()});
        }
    }

    private static void applyNativeToolSpecification(NativeToolSpecification spec, NativeBinarySpec binary) {
        for (String arg : spec.getCFlags()) {
            binary.getcCompiler().args(new String[]{arg});
        }
        for (String arg : spec.getCppFlags()) {
            binary.getCppCompiler().args(new String[]{arg});
        }
        for (String arg : spec.getLdFlags()) {
            binary.getLinker().args(new String[]{arg});
        }
    }

    public static NativeDependencyResolveResult resolveDependency(ServiceRegistry serviceRegistry, NativeBinarySpec binary, NativeSourceSet jniSource) {
        return new NativeDependencyResolver(serviceRegistry, jniSource.getDependencies(), new AndroidNativeDependencySpec(null, null, binary.getBuildType().getName(), binary.getFlavor().getName(), NativeDependencyLinkage.SHARED)).resolve();
    }

    private static void handleDependencies(NativeBinarySpec binary, NativeDependencyResolveResult dependency) {
        for (NativeLibraryArtifact artifacts : dependency.getNativeArtifacts()) {
            String abi = artifacts.getAbi();
            if (!binary.getTargetPlatform().getName().equals(abi)) continue;
            binary.getTasks().all(task -> task.dependsOn(new Object[]{artifacts.getBuiltBy()}));
            binary.lib((Object)new DefaultNativeDependencySet((NativeLibraryBinary)new NativeLibraryArtifactAdaptor(artifacts)));
        }
        for (NativeLibraryBinary prebuiltLib : dependency.getPrebuiltLibraries()) {
            if (!binary.getTargetPlatform().getName().equals(prebuiltLib.getTargetPlatform().getName())) continue;
            binary.lib((Object)new DefaultNativeDependencySet(prebuiltLib));
        }
    }

    public static Map<String, NativeSourceSet> findNativeSourceSets(NativeBinarySpec binary, ModelMap<FunctionalSourceSet> projectSourceSet) {
        HashMap sourceSetMap = Maps.newHashMap();
        NdkConfiguration.addSourceIfExist(sourceSetMap, projectSourceSet, "main");
        NdkConfiguration.addSourceIfExist(sourceSetMap, projectSourceSet, binary.getFlavor().getName());
        NdkConfiguration.addSourceIfExist(sourceSetMap, projectSourceSet, binary.getBuildType().getName());
        NdkConfiguration.addSourceIfExist(sourceSetMap, projectSourceSet, binary.getFlavor().getName() + StringHelper.capitalize((String)binary.getBuildType().getName()));
        return sourceSetMap;
    }

    private static void addSourceIfExist(Map<String, NativeSourceSet> sourceSetMap, ModelMap<FunctionalSourceSet> projectSourceSet, String sourceSetName) {
        FunctionalSourceSet sourceSet = (FunctionalSourceSet)projectSourceSet.get(sourceSetName);
        if (sourceSet != null) {
            sourceSetMap.put(sourceSetName, (NativeSourceSet)sourceSet.get("jni"));
        }
    }

    private static void addNativeSourceSets(BinarySpec binary, String sourceSetName, NativeSourceSet jni) {
        binary.getSources().create(sourceSetName + "C", CSourceSet.class, source -> {
            SourceDirectorySet sourceDir = source.getSource();
            sourceDir.setSrcDirs((Iterable)jni.getSource().getSrcDirs());
            sourceDir.include((Iterable)jni.getSource().getIncludes());
            sourceDir.exclude((Iterable)jni.getSource().getExcludes());
            sourceDir.getFilter().include((Iterable)jni.getcFilter().getIncludes());
            sourceDir.getFilter().exclude((Iterable)jni.getcFilter().getExcludes());
            source.getExportedHeaders().source(jni.getExportedHeaders());
            NdkConfiguration.configurePrebuiltDependency((DependentSourceSet)source, jni);
        });
        binary.getSources().create(sourceSetName + "Cpp", CppSourceSet.class, source -> {
            SourceDirectorySet sourceDir = source.getSource();
            sourceDir.setSrcDirs((Iterable)jni.getSource().getSrcDirs());
            sourceDir.include((Iterable)jni.getSource().getIncludes());
            sourceDir.exclude((Iterable)jni.getSource().getExcludes());
            sourceDir.getFilter().include((Iterable)jni.getCppFilter().getIncludes());
            sourceDir.getFilter().exclude((Iterable)jni.getCppFilter().getExcludes());
            source.getExportedHeaders().source(jni.getExportedHeaders());
            NdkConfiguration.configurePrebuiltDependency((DependentSourceSet)source, jni);
        });
    }

    private static void configurePrebuiltDependency(DependentSourceSet source, NativeSourceSet jni) {
        for (AndroidNativeDependencySpec dependencySpec : jni.getDependencies().getDependencies()) {
            if (dependencySpec.getLibraryPath() == null) continue;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"library", (Object)dependencySpec.getLibraryPath());
            if (dependencySpec.getLinkage() != null) {
                builder.put((Object)"linkage", (Object)dependencySpec.getLinkage().getName());
            }
            source.lib((Object)builder.build());
        }
    }

    public static void createTasks(ModelMap<Task> tasks, NativeBinarySpec binary, File buildDir, NdkConfig ndkConfig, NdkHandler ndkHandler, Multimap<String, NativeDependencyResolveResult> dependencyMap) {
        String compileNdkTaskName = NdkNamingScheme.getNdkBuildTaskName(binary);
        tasks.create(compileNdkTaskName);
        if (binary instanceof SharedLibraryBinarySpec) {
            StlConfiguration.createStlCopyTask(tasks, binary, buildDir, ndkHandler, Stl.getById((String)ndkConfig.getStl()), ndkConfig.getStlVersion(), compileNdkTaskName);
            NdkConfiguration.createCopyLibrariesTask(tasks, (SharedLibraryBinarySpec)binary, dependencyMap, buildDir, compileNdkTaskName);
        }
    }

    private static void createCopyLibrariesTask(ModelMap<Task> tasks, SharedLibraryBinarySpec binary, Multimap<String, NativeDependencyResolveResult> dependencyMap, File buildDir, String buildTaskName) {
        String taskName = NdkNamingScheme.getTaskName((NativeBinarySpec)binary, "stripSymbols");
        ArrayList artifactFiles = Lists.newArrayList();
        ArrayList prebuiltLibs = Lists.newArrayList();
        Collection dependencies = dependencyMap.get((Object)binary.getName());
        for (NativeDependencyResolveResult dependency : dependencies) {
            for (NativeLibraryArtifact artifact : dependency.getNativeArtifacts()) {
                if (!binary.getTargetPlatform().getName().equals(artifact.getAbi())) continue;
                for (File lib : artifact.getLibraries()) {
                    if (!lib.getName().endsWith(".so")) continue;
                    artifactFiles.add(lib);
                }
            }
            for (NativeLibraryBinary prebuiltLib : dependency.getPrebuiltLibraries()) {
                if (!(prebuiltLib instanceof SharedLibraryBinary) || !binary.getTargetPlatform().getName().equals(prebuiltLib.getTargetPlatform().getName())) continue;
                prebuiltLibs.add(prebuiltLib.getRuntimeFiles());
            }
        }
        tasks.create(taskName, Copy.class, (Action)new MergeNativeLibrariesConfigAction((NativeBinarySpec)binary, new File(buildDir, NdkNamingScheme.getDebugLibraryDirectoryName((NativeBinarySpec)binary)), artifactFiles, prebuiltLibs, buildDir));
        tasks.named(buildTaskName, task -> task.dependsOn(new Object[]{taskName}));
    }
}

