/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.utils.AsmUtils;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

public class ViewTagDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"ViewTag", (String)"Tagged object leaks", (String)"Prior to Android 4.0, the implementation of `View.setTag(int, Object)` would store the objects in a static map, where the values were strongly referenced. This means that if the object contains any references pointing back to the context, the context (which points to pretty much everything else) will leak. If you pass a view, the view provides a reference to the context that created it. Similarly, view holders typically contain a view, and cursors are sometimes also associated with views.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ViewTagDetector.class, Scope.CLASS_FILE_SCOPE));

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<String> getApplicableCallNames() {
        return Collections.singletonList("setTag");
    }

    public void checkCall(ClassContext context, ClassNode classNode, MethodNode method, MethodInsnNode call) {
        if (context.getMainProject().getMinSdk() >= 14) {
            return;
        }
        String owner = call.owner;
        String desc = call.desc;
        if (owner.equals("android/view/View") && desc.equals("(ILjava/lang/Object;)V")) {
            Analyzer analyzer = new Analyzer((Interpreter)new BasicInterpreter(){

                public BasicValue newValue(Type type) {
                    if (type == null) {
                        return BasicValue.UNINITIALIZED_VALUE;
                    }
                    if (type.getSort() == 0) {
                        return null;
                    }
                    return new BasicValue(type);
                }
            });
            try {
                Frame[] frames = analyzer.analyze(classNode.name, method);
                InsnList instructions = method.instructions;
                Frame frame = frames[instructions.indexOf((AbstractInsnNode)call)];
                if (frame.getStackSize() < 3) {
                    return;
                }
                BasicValue stackValue = (BasicValue)frame.getStack(2);
                Type type = stackValue.getType();
                if (type == null) {
                    return;
                }
                String internalName = type.getInternalName();
                String className = type.getClassName();
                LintDriver driver = context.getDriver();
                SdkInfo sdkInfo = context.getClient().getSdkInfo(context.getMainProject());
                String objectType = null;
                while (className != null) {
                    if (className.equals("android.view.View")) {
                        objectType = "views";
                        break;
                    }
                    if (className.endsWith("ViewHolder")) {
                        objectType = "view holders";
                        break;
                    }
                    if (className.endsWith("Cursor") && className.startsWith("android.")) {
                        objectType = "cursors";
                        break;
                    }
                    String parent = sdkInfo.getParentViewClass(className);
                    if (parent == null) {
                        if (internalName == null) {
                            internalName = AsmUtils.toInternalName((String)className);
                        }
                        assert (internalName != null);
                        parent = driver.getSuperClass(internalName);
                    }
                    className = parent;
                    internalName = null;
                }
                if (objectType != null) {
                    Location location = context.getLocation((AbstractInsnNode)call);
                    String message = String.format("Avoid setting %1$s as values for `setTag`: Can lead to memory leaks in versions older than Android 4.0", objectType);
                    context.report(ISSUE, method, (AbstractInsnNode)call, location, message);
                }
            }
            catch (AnalyzerException e) {
                context.log((Throwable)e, null, new Object[0]);
            }
        }
    }
}

