/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;

public class PluralsDatabase {
    private static final EnumSet<Quantity> NONE = EnumSet.noneOf(Quantity.class);
    private static final PluralsDatabase sInstance = new PluralsDatabase();
    private Map<String, EnumSet<Quantity>> mPlurals = Maps.newHashMap();
    static final int FLAG_ZERO = 1;
    static final int FLAG_ONE = 2;
    static final int FLAG_TWO = 4;
    static final int FLAG_FEW = 8;
    static final int FLAG_MANY = 16;
    static final int FLAG_MULTIPLE_ZERO = 32;
    static final int FLAG_MULTIPLE_ONE = 64;
    static final int FLAG_MULTIPLE_TWO = 128;
    private static final String[] LANGUAGE_CODES = new String[]{"af", "ak", "am", "ar", "az", "be", "bg", "bh", "bm", "bn", "bo", "br", "bs", "ca", "cs", "cy", "da", "de", "dv", "dz", "ee", "el", "en", "eo", "es", "et", "eu", "fa", "ff", "fi", "fo", "fr", "fy", "ga", "gd", "gl", "gu", "gv", "ha", "he", "hi", "hr", "hu", "hy", "id", "ig", "ii", "in", "is", "it", "iu", "iw", "ja", "ji", "jv", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "kw", "ky", "lb", "lg", "ln", "lo", "lt", "lv", "mg", "mk", "ml", "mn", "mr", "ms", "mt", "my", "nb", "nd", "ne", "nl", "nn", "no", "nr", "ny", "om", "or", "os", "pa", "pl", "ps", "pt", "rm", "ro", "ru", "se", "sg", "si", "sk", "sl", "sn", "so", "sq", "sr", "ss", "st", "sv", "sw", "ta", "te", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "ug", "uk", "ur", "uz", "ve", "vi", "vo", "wa", "wo", "xh", "yi", "yo", "zh", "zu"};
    private static final int[] FLAGS = new int[]{2, 66, 66, 31, 2, 90, 2, 66, 0, 66, 0, 222, 74, 2, 10, 31, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 66, 66, 2, 2, 66, 2, 30, 206, 2, 66, 206, 2, 22, 66, 74, 2, 66, 0, 0, 0, 0, 66, 2, 6, 22, 0, 2, 0, 2, 2, 2, 0, 66, 0, 2, 2, 6, 2, 2, 2, 66, 0, 74, 99, 66, 66, 2, 2, 66, 0, 26, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 66, 26, 2, 2, 2, 10, 90, 6, 0, 66, 10, 206, 2, 2, 2, 74, 2, 2, 2, 2, 2, 2, 0, 66, 2, 66, 2, 0, 2, 2, 2, 90, 2, 2, 2, 0, 2, 66, 0, 2, 2, 0, 0, 66};

    public static PluralsDatabase get() {
        return sInstance;
    }

    private static int getFlags(String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        if (index != -1) {
            return FLAGS[index];
        }
        return 0;
    }

    private static int getLanguageIndex(String language) {
        int index = Arrays.binarySearch(LANGUAGE_CODES, language);
        if (index >= 0) {
            assert (LANGUAGE_CODES[index].equals(language));
            return index;
        }
        return -1;
    }

    public EnumSet<Quantity> getRelevant(String language) {
        EnumSet<Quantity> set = this.mPlurals.get(language);
        if (set == null) {
            int index = PluralsDatabase.getLanguageIndex(language);
            if (index == -1) {
                this.mPlurals.put(language, NONE);
                return null;
            }
            int flag = FLAGS[index];
            set = EnumSet.noneOf(Quantity.class);
            if ((flag & 1) != 0) {
                set.add(Quantity.zero);
            }
            if ((flag & 2) != 0) {
                set.add(Quantity.one);
            }
            if ((flag & 4) != 0) {
                set.add(Quantity.two);
            }
            if ((flag & 8) != 0) {
                set.add(Quantity.few);
            }
            if ((flag & 0x10) != 0) {
                set.add(Quantity.many);
            }
            this.mPlurals.put(language, set);
        }
        return set == NONE ? null : set;
    }

    public boolean hasMultipleValuesForQuantity(String language, Quantity quantity) {
        if (quantity == Quantity.one) {
            return (PluralsDatabase.getFlags(language) & 0x40) != 0;
        }
        if (quantity == Quantity.two) {
            return (PluralsDatabase.getFlags(language) & 0x80) != 0;
        }
        return quantity == Quantity.zero && (PluralsDatabase.getFlags(language) & 0x20) != 0;
    }

    public String findIntegerExamples(String language, Quantity quantity) {
        if (quantity == Quantity.one) {
            return PluralsDatabase.getExampleForQuantityOne(language);
        }
        if (quantity == Quantity.two) {
            return PluralsDatabase.getExampleForQuantityTwo(language);
        }
        if (quantity == Quantity.zero) {
            return PluralsDatabase.getExampleForQuantityZero(language);
        }
        return null;
    }

    private static String getExampleForQuantityZero(String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        switch (index) {
            case 70: {
                return "0, 10~20, 30, 40, 50, 60, 100, 1000, 10000, 100000, 1000000, \u2026";
            }
        }
        return null;
    }

    private static String getExampleForQuantityOne(String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        switch (index) {
            case 2: 
            case 9: 
            case 27: 
            case 36: 
            case 40: 
            case 59: 
            case 75: 
            case 133: {
                return "0, 1";
            }
            case 48: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 72: {
                return "1, 11, 21, 31, 41, 51, 61, 71, 101, 1001, \u2026";
            }
            case 115: {
                return "0~3, 5, 7, 8, 10~13, 15, 17, 18, 20, 21, 100, 1000, 10000, 100000, 1000000, \u2026";
            }
            case 70: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 28: 
            case 31: 
            case 43: {
                return "0, 1";
            }
            case 12: 
            case 41: 
            case 105: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 34: {
                return "1, 11";
            }
            case 101: {
                return "1, 101, 201, 301, 401, 501, 601, 701, 1001, \u2026";
            }
            case 5: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 69: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 96: 
            case 121: {
                return "1, 21, 31, 41, 51, 61, 71, 81, 101, 1001, \u2026";
            }
            case 11: {
                return "1, 21, 31, 41, 51, 61, 81, 101, 1001, \u2026";
            }
            case 37: {
                return "1, 11, 21, 31, 41, 51, 61, 71, 101, 1001, \u2026";
            }
            case 99: {
                return "0, 1";
            }
            case 1: 
            case 7: 
            case 67: 
            case 71: 
            case 90: 
            case 113: 
            case 127: {
                return "0, 1";
            }
        }
        return null;
    }

    private static String getExampleForQuantityTwo(String language) {
        int index = PluralsDatabase.getLanguageIndex(language);
        switch (index) {
            case 34: {
                return "2, 12";
            }
            case 101: {
                return "2, 102, 202, 302, 402, 502, 602, 702, 1002, \u2026";
            }
            case 11: {
                return "2, 22, 32, 42, 52, 62, 82, 102, 1002, \u2026";
            }
            case 37: {
                return "2, 12, 22, 32, 42, 52, 62, 72, 102, 1002, \u2026";
            }
        }
        return null;
    }

    public static enum Quantity {
        few,
        many,
        one,
        two,
        zero,
        other;


        public static Quantity get(String name) {
            for (Quantity quantity : Quantity.values()) {
                if (!name.equals(quantity.name())) continue;
                return quantity;
            }
            return null;
        }

        public static String formatSet(EnumSet<Quantity> set) {
            ArrayList<String> list = new ArrayList<String>(set.size());
            for (Quantity quantity : set) {
                list.add('`' + quantity.name() + '`');
            }
            return LintUtils.formatList(list, (int)Integer.MAX_VALUE);
        }
    }
}

