/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import java.util.List;
import java.util.Map;
import org.testng.xml.Parser;

public class TestNGTestSuite
extends TestNGTestObject {
    private static final Object PARSE_LOCK = new Object();

    public TestNGTestSuite(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
    }

    @Override
    public String getGeneratedName() {
        return this.myConfig.getPersistantData().getSuiteName();
    }

    @Override
    public String getActionName() {
        return this.myConfig.getPersistantData().getSuiteName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        TestData data = this.myConfig.getPersistantData();
        try {
            Parser parser = new Parser(data.getSuiteName());
            parser.setLoadClasses(false);
            Object object = PARSE_LOCK;
            synchronized (object) {
                parser.parse();
            }
        }
        catch (Exception e) {
            throw new RuntimeConfigurationException("Unable to parse '" + data.getSuiteName() + "' specified");
        }
    }

    @Override
    public boolean isConfiguredByElement(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof XmlFile) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
            return virtualFile != null && Comparing.strEqual((String)this.myConfig.getPersistantData().getSuiteName(), (String)virtualFile.getPath());
        }
        return false;
    }
}

