/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertOldAnnotationInspection
extends BaseJavaLocalInspectionTool {
    private static final String DISPLAY_NAME = "Convert old @Configuration TestNG annotations";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "ConvertOldAnnotations";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                String qualifiedName = annotation.getQualifiedName();
                if (Comparing.strEqual((String)qualifiedName, (String)"org.testng.annotations.Configuration")) {
                    holder.registerProblem((PsiElement)annotation, ConvertOldAnnotationInspection.DISPLAY_NAME, new LocalQuickFix[]{new ConvertOldAnnotationsQuickfix()});
                }
            }
        };
    }

    private static void convertOldAnnotationAttributeToAnnotation(PsiModifierList modifierList, PsiAnnotation annotation, @NonNls String attribute, @NonNls String newAnnotation) throws IncorrectOperationException {
        PsiAnnotationParameterList list = annotation.getParameterList();
        for (PsiNameValuePair pair : list.getAttributes()) {
            if (!attribute.equals(pair.getName())) continue;
            StringBuffer newAnnotationBuffer = new StringBuffer();
            newAnnotationBuffer.append(newAnnotation).append('(').append(')');
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)annotation.getProject()).getElementFactory();
            PsiAnnotation newPsiAnnotation = factory.createAnnotationFromText(newAnnotationBuffer.toString(), (PsiElement)modifierList);
            JavaCodeStyleManager.getInstance((Project)annotation.getProject()).shortenClassReferences(modifierList.addAfter((PsiElement)newPsiAnnotation, null));
        }
    }

    private static class ConvertOldAnnotationsQuickfix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance((String)("#" + ConvertOldAnnotationsQuickfix.class.getName()));

        private ConvertOldAnnotationsQuickfix() {
        }

        @NotNull
        public String getName() {
            return ConvertOldAnnotationInspection.DISPLAY_NAME;
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiAnnotation annotation = (PsiAnnotation)descriptor.getPsiElement();
            if (!TestNGUtil.checkTestNGInClasspath((PsiElement)annotation)) {
                return;
            }
            PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierList.class);
            LOG.assertTrue(modifierList != null);
            try {
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeTest", "@org.testng.annotations.BeforeTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeTestClass", "@org.testng.annotations.BeforeTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeTestMethod", "@org.testng.annotations.BeforeMethod");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeSuite", "@org.testng.annotations.BeforeSuite");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeGroups", "@org.testng.annotations.BeforeGroups");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterTest", "@org.testng.annotations.AfterTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterTestClass", "@org.testng.annotations.AfterTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterTestMethod", "@org.testng.annotations.AfterMethod");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterSuite", "@org.testng.annotations.AfterSuite");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterGroups", "@org.testng.annotations.AfterGroups");
                annotation.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

